/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single Excel XLSX file corresponding to one worksheet (tab) in the original spreadsheet")
@JsonPropertyOrder(value={"WorksheetNumber", "WorksheetName", "URL", "WorksheetContents"})
@JsonTypeName(value="WorksheetResult")
public class WorksheetResult {
    public static final String JSON_PROPERTY_WORKSHEET_NUMBER = "WorksheetNumber";
    private Integer worksheetNumber;
    public static final String JSON_PROPERTY_WORKSHEET_NAME = "WorksheetName";
    private String worksheetName;
    public static final String JSON_PROPERTY_U_R_L = "URL";
    private String URL;
    public static final String JSON_PROPERTY_WORKSHEET_CONTENTS = "WorksheetContents";
    private byte[] worksheetContents;

    public WorksheetResult worksheetNumber(Integer worksheetNumber) {
        this.worksheetNumber = worksheetNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Worksheet number of the converted page, starting with 1 for the left-most worksheet")
    @JsonProperty(value="WorksheetNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWorksheetNumber() {
        return this.worksheetNumber;
    }

    public void setWorksheetNumber(Integer worksheetNumber) {
        this.worksheetNumber = worksheetNumber;
    }

    public WorksheetResult worksheetName(String worksheetName) {
        this.worksheetName = worksheetName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the worksheet")
    @JsonProperty(value="WorksheetName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorksheetName() {
        return this.worksheetName;
    }

    public void setWorksheetName(String worksheetName) {
        this.worksheetName = worksheetName;
    }

    public WorksheetResult URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to the XLSX file of this worksheet; file is stored in an in-memory cache and will be deleted")
    @JsonProperty(value="URL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public WorksheetResult worksheetContents(byte[] worksheetContents) {
        this.worksheetContents = worksheetContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contents of the worksheet in bytes")
    @JsonProperty(value="WorksheetContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getWorksheetContents() {
        return this.worksheetContents;
    }

    public void setWorksheetContents(byte[] worksheetContents) {
        this.worksheetContents = worksheetContents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorksheetResult worksheetResult = (WorksheetResult)o;
        return Objects.equals(this.worksheetNumber, worksheetResult.worksheetNumber) && Objects.equals(this.worksheetName, worksheetResult.worksheetName) && Objects.equals(this.URL, worksheetResult.URL) && Arrays.equals(this.worksheetContents, worksheetResult.worksheetContents);
    }

    public int hashCode() {
        return Objects.hash(this.worksheetNumber, this.worksheetName, this.URL, Arrays.hashCode(this.worksheetContents));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorksheetResult {\n");
        sb.append("    worksheetNumber: ").append(this.toIndentedString(this.worksheetNumber)).append("\n");
        sb.append("    worksheetName: ").append(this.toIndentedString(this.worksheetName)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("    worksheetContents: ").append(this.toIndentedString(this.worksheetContents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

