/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"Word", "WordIndex", "StartPosition", "EndPosition"})
@JsonTypeName(value="WordPosition")
public class WordPosition {
    public static final String JSON_PROPERTY_WORD = "Word";
    private String word;
    public static final String JSON_PROPERTY_WORD_INDEX = "WordIndex";
    private Integer wordIndex;
    public static final String JSON_PROPERTY_START_POSITION = "StartPosition";
    private Integer startPosition;
    public static final String JSON_PROPERTY_END_POSITION = "EndPosition";
    private Integer endPosition;

    public WordPosition word(String word) {
        this.word = word;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Word as a string")
    @JsonProperty(value="Word")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public WordPosition wordIndex(Integer wordIndex) {
        this.wordIndex = wordIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Zero-based index of the word; first word has index 0, second word has index 1 and so on")
    @JsonProperty(value="WordIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWordIndex() {
        return this.wordIndex;
    }

    public void setWordIndex(Integer wordIndex) {
        this.wordIndex = wordIndex;
    }

    public WordPosition startPosition(Integer startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Zero-based character offset at which the word begins in the input string")
    @JsonProperty(value="StartPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(Integer startPosition) {
        this.startPosition = startPosition;
    }

    public WordPosition endPosition(Integer endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Zero-based character offset at which the word ends in the input string")
    @JsonProperty(value="EndPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(Integer endPosition) {
        this.endPosition = endPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordPosition wordPosition = (WordPosition)o;
        return Objects.equals(this.word, wordPosition.word) && Objects.equals(this.wordIndex, wordPosition.wordIndex) && Objects.equals(this.startPosition, wordPosition.startPosition) && Objects.equals(this.endPosition, wordPosition.endPosition);
    }

    public int hashCode() {
        return Objects.hash(this.word, this.wordIndex, this.startPosition, this.endPosition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WordPosition {\n");
        sb.append("    word: ").append(this.toIndentedString(this.word)).append("\n");
        sb.append("    wordIndex: ").append(this.toIndentedString(this.wordIndex)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

