/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Result of a WHOIS operation")
@JsonPropertyOrder(value={"ValidDomain", "RegistrantName", "RegistrantOrganization", "RegistrantEmail", "RegistrantStreetNumber", "RegistrantStreet", "RegistrantCity", "RegistrantStateOrProvince", "RegistrantPostalCode", "RegistrantCountry", "RegistrantRawAddress", "RegistrantTelephone", "WhoisServer", "RawTextRecord", "CreatedDt"})
@JsonTypeName(value="WhoisResponse")
public class WhoisResponse {
    public static final String JSON_PROPERTY_VALID_DOMAIN = "ValidDomain";
    private Boolean validDomain;
    public static final String JSON_PROPERTY_REGISTRANT_NAME = "RegistrantName";
    private String registrantName;
    public static final String JSON_PROPERTY_REGISTRANT_ORGANIZATION = "RegistrantOrganization";
    private String registrantOrganization;
    public static final String JSON_PROPERTY_REGISTRANT_EMAIL = "RegistrantEmail";
    private String registrantEmail;
    public static final String JSON_PROPERTY_REGISTRANT_STREET_NUMBER = "RegistrantStreetNumber";
    private String registrantStreetNumber;
    public static final String JSON_PROPERTY_REGISTRANT_STREET = "RegistrantStreet";
    private String registrantStreet;
    public static final String JSON_PROPERTY_REGISTRANT_CITY = "RegistrantCity";
    private String registrantCity;
    public static final String JSON_PROPERTY_REGISTRANT_STATE_OR_PROVINCE = "RegistrantStateOrProvince";
    private String registrantStateOrProvince;
    public static final String JSON_PROPERTY_REGISTRANT_POSTAL_CODE = "RegistrantPostalCode";
    private String registrantPostalCode;
    public static final String JSON_PROPERTY_REGISTRANT_COUNTRY = "RegistrantCountry";
    private String registrantCountry;
    public static final String JSON_PROPERTY_REGISTRANT_RAW_ADDRESS = "RegistrantRawAddress";
    private String registrantRawAddress;
    public static final String JSON_PROPERTY_REGISTRANT_TELEPHONE = "RegistrantTelephone";
    private String registrantTelephone;
    public static final String JSON_PROPERTY_WHOIS_SERVER = "WhoisServer";
    private String whoisServer;
    public static final String JSON_PROPERTY_RAW_TEXT_RECORD = "RawTextRecord";
    private String rawTextRecord;
    public static final String JSON_PROPERTY_CREATED_DT = "CreatedDt";
    private OffsetDateTime createdDt;

    public WhoisResponse validDomain(Boolean validDomain) {
        this.validDomain = validDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the domain is valid, false if it is not")
    @JsonProperty(value="ValidDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidDomain() {
        return this.validDomain;
    }

    public void setValidDomain(Boolean validDomain) {
        this.validDomain = validDomain;
    }

    public WhoisResponse registrantName(String registrantName) {
        this.registrantName = registrantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the domain registrant")
    @JsonProperty(value="RegistrantName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantName() {
        return this.registrantName;
    }

    public void setRegistrantName(String registrantName) {
        this.registrantName = registrantName;
    }

    public WhoisResponse registrantOrganization(String registrantOrganization) {
        this.registrantOrganization = registrantOrganization;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Organization name of the domain registrant")
    @JsonProperty(value="RegistrantOrganization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantOrganization() {
        return this.registrantOrganization;
    }

    public void setRegistrantOrganization(String registrantOrganization) {
        this.registrantOrganization = registrantOrganization;
    }

    public WhoisResponse registrantEmail(String registrantEmail) {
        this.registrantEmail = registrantEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Email address of the domain registrant")
    @JsonProperty(value="RegistrantEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantEmail() {
        return this.registrantEmail;
    }

    public void setRegistrantEmail(String registrantEmail) {
        this.registrantEmail = registrantEmail;
    }

    public WhoisResponse registrantStreetNumber(String registrantStreetNumber) {
        this.registrantStreetNumber = registrantStreetNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street number of the address of the domain registrant, if available")
    @JsonProperty(value="RegistrantStreetNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantStreetNumber() {
        return this.registrantStreetNumber;
    }

    public void setRegistrantStreetNumber(String registrantStreetNumber) {
        this.registrantStreetNumber = registrantStreetNumber;
    }

    public WhoisResponse registrantStreet(String registrantStreet) {
        this.registrantStreet = registrantStreet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street name of the address of the domain registrant, if available")
    @JsonProperty(value="RegistrantStreet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantStreet() {
        return this.registrantStreet;
    }

    public void setRegistrantStreet(String registrantStreet) {
        this.registrantStreet = registrantStreet;
    }

    public WhoisResponse registrantCity(String registrantCity) {
        this.registrantCity = registrantCity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="City of the domain registrant, if available")
    @JsonProperty(value="RegistrantCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantCity() {
        return this.registrantCity;
    }

    public void setRegistrantCity(String registrantCity) {
        this.registrantCity = registrantCity;
    }

    public WhoisResponse registrantStateOrProvince(String registrantStateOrProvince) {
        this.registrantStateOrProvince = registrantStateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State or Province of the address of the domain registrant, if available")
    @JsonProperty(value="RegistrantStateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantStateOrProvince() {
        return this.registrantStateOrProvince;
    }

    public void setRegistrantStateOrProvince(String registrantStateOrProvince) {
        this.registrantStateOrProvince = registrantStateOrProvince;
    }

    public WhoisResponse registrantPostalCode(String registrantPostalCode) {
        this.registrantPostalCode = registrantPostalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Postal code of the address of the domain registrant, if available")
    @JsonProperty(value="RegistrantPostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantPostalCode() {
        return this.registrantPostalCode;
    }

    public void setRegistrantPostalCode(String registrantPostalCode) {
        this.registrantPostalCode = registrantPostalCode;
    }

    public WhoisResponse registrantCountry(String registrantCountry) {
        this.registrantCountry = registrantCountry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country of the address of the domain registrant, if available")
    @JsonProperty(value="RegistrantCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantCountry() {
        return this.registrantCountry;
    }

    public void setRegistrantCountry(String registrantCountry) {
        this.registrantCountry = registrantCountry;
    }

    public WhoisResponse registrantRawAddress(String registrantRawAddress) {
        this.registrantRawAddress = registrantRawAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Raw address string of the domain registrant, if available")
    @JsonProperty(value="RegistrantRawAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantRawAddress() {
        return this.registrantRawAddress;
    }

    public void setRegistrantRawAddress(String registrantRawAddress) {
        this.registrantRawAddress = registrantRawAddress;
    }

    public WhoisResponse registrantTelephone(String registrantTelephone) {
        this.registrantTelephone = registrantTelephone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Telephone number of the address of the domain registrant")
    @JsonProperty(value="RegistrantTelephone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrantTelephone() {
        return this.registrantTelephone;
    }

    public void setRegistrantTelephone(String registrantTelephone) {
        this.registrantTelephone = registrantTelephone;
    }

    public WhoisResponse whoisServer(String whoisServer) {
        this.whoisServer = whoisServer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Server used to lookup WHOIS information (may change based on lookup).")
    @JsonProperty(value="WhoisServer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhoisServer() {
        return this.whoisServer;
    }

    public void setWhoisServer(String whoisServer) {
        this.whoisServer = whoisServer;
    }

    public WhoisResponse rawTextRecord(String rawTextRecord) {
        this.rawTextRecord = rawTextRecord;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="WHOIS raw text record")
    @JsonProperty(value="RawTextRecord")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRawTextRecord() {
        return this.rawTextRecord;
    }

    public void setRawTextRecord(String rawTextRecord) {
        this.rawTextRecord = rawTextRecord;
    }

    public WhoisResponse createdDt(OffsetDateTime createdDt) {
        this.createdDt = createdDt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Creation date for the record")
    @JsonProperty(value="CreatedDt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedDt() {
        return this.createdDt;
    }

    public void setCreatedDt(OffsetDateTime createdDt) {
        this.createdDt = createdDt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhoisResponse whoisResponse = (WhoisResponse)o;
        return Objects.equals(this.validDomain, whoisResponse.validDomain) && Objects.equals(this.registrantName, whoisResponse.registrantName) && Objects.equals(this.registrantOrganization, whoisResponse.registrantOrganization) && Objects.equals(this.registrantEmail, whoisResponse.registrantEmail) && Objects.equals(this.registrantStreetNumber, whoisResponse.registrantStreetNumber) && Objects.equals(this.registrantStreet, whoisResponse.registrantStreet) && Objects.equals(this.registrantCity, whoisResponse.registrantCity) && Objects.equals(this.registrantStateOrProvince, whoisResponse.registrantStateOrProvince) && Objects.equals(this.registrantPostalCode, whoisResponse.registrantPostalCode) && Objects.equals(this.registrantCountry, whoisResponse.registrantCountry) && Objects.equals(this.registrantRawAddress, whoisResponse.registrantRawAddress) && Objects.equals(this.registrantTelephone, whoisResponse.registrantTelephone) && Objects.equals(this.whoisServer, whoisResponse.whoisServer) && Objects.equals(this.rawTextRecord, whoisResponse.rawTextRecord) && Objects.equals(this.createdDt, whoisResponse.createdDt);
    }

    public int hashCode() {
        return Objects.hash(this.validDomain, this.registrantName, this.registrantOrganization, this.registrantEmail, this.registrantStreetNumber, this.registrantStreet, this.registrantCity, this.registrantStateOrProvince, this.registrantPostalCode, this.registrantCountry, this.registrantRawAddress, this.registrantTelephone, this.whoisServer, this.rawTextRecord, this.createdDt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhoisResponse {\n");
        sb.append("    validDomain: ").append(this.toIndentedString(this.validDomain)).append("\n");
        sb.append("    registrantName: ").append(this.toIndentedString(this.registrantName)).append("\n");
        sb.append("    registrantOrganization: ").append(this.toIndentedString(this.registrantOrganization)).append("\n");
        sb.append("    registrantEmail: ").append(this.toIndentedString(this.registrantEmail)).append("\n");
        sb.append("    registrantStreetNumber: ").append(this.toIndentedString(this.registrantStreetNumber)).append("\n");
        sb.append("    registrantStreet: ").append(this.toIndentedString(this.registrantStreet)).append("\n");
        sb.append("    registrantCity: ").append(this.toIndentedString(this.registrantCity)).append("\n");
        sb.append("    registrantStateOrProvince: ").append(this.toIndentedString(this.registrantStateOrProvince)).append("\n");
        sb.append("    registrantPostalCode: ").append(this.toIndentedString(this.registrantPostalCode)).append("\n");
        sb.append("    registrantCountry: ").append(this.toIndentedString(this.registrantCountry)).append("\n");
        sb.append("    registrantRawAddress: ").append(this.toIndentedString(this.registrantRawAddress)).append("\n");
        sb.append("    registrantTelephone: ").append(this.toIndentedString(this.registrantTelephone)).append("\n");
        sb.append("    whoisServer: ").append(this.toIndentedString(this.whoisServer)).append("\n");
        sb.append("    rawTextRecord: ").append(this.toIndentedString(this.rawTextRecord)).append("\n");
        sb.append("    createdDt: ").append(this.toIndentedString(this.createdDt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

