/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.VirusFound;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of running a website scan")
@JsonPropertyOrder(value={"CleanResult", "WebsiteThreatType", "FoundViruses", "WebsiteHttpResponseCode"})
@JsonTypeName(value="WebsiteScanResult")
public class WebsiteScanResult {
    public static final String JSON_PROPERTY_CLEAN_RESULT = "CleanResult";
    private Boolean cleanResult;
    public static final String JSON_PROPERTY_WEBSITE_THREAT_TYPE = "WebsiteThreatType";
    private WebsiteThreatTypeEnum websiteThreatType;
    public static final String JSON_PROPERTY_FOUND_VIRUSES = "FoundViruses";
    private List<VirusFound> foundViruses = null;
    public static final String JSON_PROPERTY_WEBSITE_HTTP_RESPONSE_CODE = "WebsiteHttpResponseCode";
    private Integer websiteHttpResponseCode;

    public WebsiteScanResult cleanResult(Boolean cleanResult) {
        this.cleanResult = cleanResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the scan contained no threats, false otherwise")
    @JsonProperty(value="CleanResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCleanResult() {
        return this.cleanResult;
    }

    public void setCleanResult(Boolean cleanResult) {
        this.cleanResult = cleanResult;
    }

    public WebsiteScanResult websiteThreatType(WebsiteThreatTypeEnum websiteThreatType) {
        this.websiteThreatType = websiteThreatType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of threat returned; can be None, Malware, ForcedDownload or Phishing")
    @JsonProperty(value="WebsiteThreatType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebsiteThreatTypeEnum getWebsiteThreatType() {
        return this.websiteThreatType;
    }

    public void setWebsiteThreatType(WebsiteThreatTypeEnum websiteThreatType) {
        this.websiteThreatType = websiteThreatType;
    }

    public WebsiteScanResult foundViruses(List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
        return this;
    }

    public WebsiteScanResult addFoundVirusesItem(VirusFound foundVirusesItem) {
        if (this.foundViruses == null) {
            this.foundViruses = new ArrayList<VirusFound>();
        }
        this.foundViruses.add(foundVirusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of viruses found, if any")
    @JsonProperty(value="FoundViruses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VirusFound> getFoundViruses() {
        return this.foundViruses;
    }

    public void setFoundViruses(List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
    }

    public WebsiteScanResult websiteHttpResponseCode(Integer websiteHttpResponseCode) {
        this.websiteHttpResponseCode = websiteHttpResponseCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The remote server URL HTTP reasponse code; useful for debugging issues with scanning; typically if the remote server returns a 200 or 300-series code this means a successful response, while a 400 or 500 series code would represent an error returned from the remote server for the provided URL.")
    @JsonProperty(value="WebsiteHttpResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWebsiteHttpResponseCode() {
        return this.websiteHttpResponseCode;
    }

    public void setWebsiteHttpResponseCode(Integer websiteHttpResponseCode) {
        this.websiteHttpResponseCode = websiteHttpResponseCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebsiteScanResult websiteScanResult = (WebsiteScanResult)o;
        return Objects.equals(this.cleanResult, websiteScanResult.cleanResult) && Objects.equals((Object)this.websiteThreatType, (Object)websiteScanResult.websiteThreatType) && Objects.equals(this.foundViruses, websiteScanResult.foundViruses) && Objects.equals(this.websiteHttpResponseCode, websiteScanResult.websiteHttpResponseCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cleanResult, this.websiteThreatType, this.foundViruses, this.websiteHttpResponseCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebsiteScanResult {\n");
        sb.append("    cleanResult: ").append(this.toIndentedString(this.cleanResult)).append("\n");
        sb.append("    websiteThreatType: ").append(this.toIndentedString((Object)this.websiteThreatType)).append("\n");
        sb.append("    foundViruses: ").append(this.toIndentedString(this.foundViruses)).append("\n");
        sb.append("    websiteHttpResponseCode: ").append(this.toIndentedString(this.websiteHttpResponseCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum WebsiteThreatTypeEnum {
        NONE("None"),
        MALWARE("Malware"),
        PHISHING("Phishing"),
        FORCEDDOWNLOAD("ForcedDownload"),
        UNABLETOCONNECT("UnableToConnect");

        private String value;

        private WebsiteThreatTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WebsiteThreatTypeEnum fromValue(String value) {
            for (WebsiteThreatTypeEnum b : WebsiteThreatTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

