/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of validating a postal code")
@JsonPropertyOrder(value={"ValidPostalCode", "City", "StateOrProvince", "Latitude", "Longitude"})
@JsonTypeName(value="ValidatePostalCodeResponse")
public class ValidatePostalCodeResponse {
    public static final String JSON_PROPERTY_VALID_POSTAL_CODE = "ValidPostalCode";
    private Boolean validPostalCode;
    public static final String JSON_PROPERTY_CITY = "City";
    private String city;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "StateOrProvince";
    private String stateOrProvince;
    public static final String JSON_PROPERTY_LATITUDE = "Latitude";
    private Double latitude;
    public static final String JSON_PROPERTY_LONGITUDE = "Longitude";
    private Double longitude;

    public ValidatePostalCodeResponse validPostalCode(Boolean validPostalCode) {
        this.validPostalCode = validPostalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the Postal Code is valid, false otherwise")
    @JsonProperty(value="ValidPostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidPostalCode() {
        return this.validPostalCode;
    }

    public void setValidPostalCode(Boolean validPostalCode) {
        this.validPostalCode = validPostalCode;
    }

    public ValidatePostalCodeResponse city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If valid, City corresponding to the input postal code, such as 'Walnut Creek'")
    @JsonProperty(value="City")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public ValidatePostalCodeResponse stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If valid; State or province corresponding to the input postal code, such as 'CA' or 'California'")
    @JsonProperty(value="StateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public ValidatePostalCodeResponse latitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the postal code is valid, the degrees latitude of the centroid of the postal code, null otherwise")
    @JsonProperty(value="Latitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public ValidatePostalCodeResponse longitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the postal code is valid, the degrees longitude of the centroid of the postal code, null otherwise")
    @JsonProperty(value="Longitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatePostalCodeResponse validatePostalCodeResponse = (ValidatePostalCodeResponse)o;
        return Objects.equals(this.validPostalCode, validatePostalCodeResponse.validPostalCode) && Objects.equals(this.city, validatePostalCodeResponse.city) && Objects.equals(this.stateOrProvince, validatePostalCodeResponse.stateOrProvince) && Objects.equals(this.latitude, validatePostalCodeResponse.latitude) && Objects.equals(this.longitude, validatePostalCodeResponse.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.validPostalCode, this.city, this.stateOrProvince, this.latitude, this.longitude);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidatePostalCodeResponse {\n");
        sb.append("    validPostalCode: ").append(this.toIndentedString(this.validPostalCode)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    latitude: ").append(this.toIndentedString(this.latitude)).append("\n");
        sb.append("    longitude: ").append(this.toIndentedString(this.longitude)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

