/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to Validate a Postal Code")
@JsonPropertyOrder(value={"PostalCode", "CountryFullName", "CountryCode"})
@JsonTypeName(value="ValidatePostalCodeRequest")
public class ValidatePostalCodeRequest {
    public static final String JSON_PROPERTY_POSTAL_CODE = "PostalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTRY_FULL_NAME = "CountryFullName";
    private String countryFullName;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
    private String countryCode;

    public ValidatePostalCodeRequest postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required: Zip code or postal code of the address to validate, such as '94597'")
    @JsonProperty(value="PostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public ValidatePostalCodeRequest countryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional (recommended); Name of the country, such as 'United States'.  If left blank, and CountryCode is also left blank, will default to United States.  Global countries are supported.")
    @JsonProperty(value="CountryFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryFullName() {
        return this.countryFullName;
    }

    public void setCountryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
    }

    public ValidatePostalCodeRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; two-letter country code (Two-letter ISO 3166-1 country code) of the country.  If left blank, and CountryFullName is also left blank, will default to United States.  Global countries are supported.")
    @JsonProperty(value="CountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatePostalCodeRequest validatePostalCodeRequest = (ValidatePostalCodeRequest)o;
        return Objects.equals(this.postalCode, validatePostalCodeRequest.postalCode) && Objects.equals(this.countryFullName, validatePostalCodeRequest.countryFullName) && Objects.equals(this.countryCode, validatePostalCodeRequest.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.postalCode, this.countryFullName, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidatePostalCodeRequest {\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryFullName: ").append(this.toIndentedString(this.countryFullName)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

