/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of validating a city")
@JsonPropertyOrder(value={"ValidCity", "City", "StateOrProvince", "Latitude", "Longitude"})
@JsonTypeName(value="ValidateCityResponse")
public class ValidateCityResponse {
    public static final String JSON_PROPERTY_VALID_CITY = "ValidCity";
    private Boolean validCity;
    public static final String JSON_PROPERTY_CITY = "City";
    private String city;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "StateOrProvince";
    private String stateOrProvince;
    public static final String JSON_PROPERTY_LATITUDE = "Latitude";
    private Double latitude;
    public static final String JSON_PROPERTY_LONGITUDE = "Longitude";
    private Double longitude;

    public ValidateCityResponse validCity(Boolean validCity) {
        this.validCity = validCity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the city is valid, false otherwise")
    @JsonProperty(value="ValidCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidCity() {
        return this.validCity;
    }

    public void setValidCity(Boolean validCity) {
        this.validCity = validCity;
    }

    public ValidateCityResponse city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If valid, City corresponding to the input postal code, such as 'Walnut Creek'")
    @JsonProperty(value="City")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public ValidateCityResponse stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If valid; State or province corresponding to the input state name, such as 'CA' or 'California'")
    @JsonProperty(value="StateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public ValidateCityResponse latitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the postal code is valid, the degrees latitude of the centroid of the state, null otherwise")
    @JsonProperty(value="Latitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public ValidateCityResponse longitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the postal code is valid, the degrees longitude of the centroid of the state, null otherwise")
    @JsonProperty(value="Longitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidateCityResponse validateCityResponse = (ValidateCityResponse)o;
        return Objects.equals(this.validCity, validateCityResponse.validCity) && Objects.equals(this.city, validateCityResponse.city) && Objects.equals(this.stateOrProvince, validateCityResponse.stateOrProvince) && Objects.equals(this.latitude, validateCityResponse.latitude) && Objects.equals(this.longitude, validateCityResponse.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.validCity, this.city, this.stateOrProvince, this.latitude, this.longitude);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidateCityResponse {\n");
        sb.append("    validCity: ").append(this.toIndentedString(this.validCity)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    latitude: ").append(this.toIndentedString(this.latitude)).append("\n");
        sb.append("    longitude: ").append(this.toIndentedString(this.longitude)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

