/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to Validate a City and State or Province in a country")
@JsonPropertyOrder(value={"City", "StateOrProvince", "CountryFullName", "CountryCode"})
@JsonTypeName(value="ValidateCityRequest")
public class ValidateCityRequest {
    public static final String JSON_PROPERTY_CITY = "City";
    private String city;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "StateOrProvince";
    private String stateOrProvince;
    public static final String JSON_PROPERTY_COUNTRY_FULL_NAME = "CountryFullName";
    private String countryFullName;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
    private String countryCode;

    public ValidateCityRequest city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required: City of the address to validate, such as 'San Francisco' or 'London'")
    @JsonProperty(value="City")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public ValidateCityRequest stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required: State or province of the address to validate, such as 'California' or 'CA'")
    @JsonProperty(value="StateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public ValidateCityRequest countryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional (recommended); Name of the country, such as 'United States'.  If left blank, and CountryCode is also left blank, will default to United States.  Global countries are supported.")
    @JsonProperty(value="CountryFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryFullName() {
        return this.countryFullName;
    }

    public void setCountryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
    }

    public ValidateCityRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; two-letter country code (Two-letter ISO 3166-1 country code) of the country.  If left blank, and CountryFullName is also left blank, will default to United States.  Global countries are supported.")
    @JsonProperty(value="CountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidateCityRequest validateCityRequest = (ValidateCityRequest)o;
        return Objects.equals(this.city, validateCityRequest.city) && Objects.equals(this.stateOrProvince, validateCityRequest.stateOrProvince) && Objects.equals(this.countryFullName, validateCityRequest.countryFullName) && Objects.equals(this.countryCode, validateCityRequest.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.stateOrProvince, this.countryFullName, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidateCityRequest {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    countryFullName: ").append(this.toIndentedString(this.countryFullName)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

