/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to Validate a Street Address")
@JsonPropertyOrder(value={"StreetAddress", "City", "StateOrProvince", "PostalCode", "CountryFullName", "CountryCode"})
@JsonTypeName(value="ValidateAddressRequest")
public class ValidateAddressRequest {
    public static final String JSON_PROPERTY_STREET_ADDRESS = "StreetAddress";
    private String streetAddress;
    public static final String JSON_PROPERTY_CITY = "City";
    private String city;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "StateOrProvince";
    private String stateOrProvince;
    public static final String JSON_PROPERTY_POSTAL_CODE = "PostalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTRY_FULL_NAME = "CountryFullName";
    private String countryFullName;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
    private String countryCode;

    public ValidateAddressRequest streetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required; Street address to validate, such as '2950 Buskirk Ave.'")
    @JsonProperty(value="StreetAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public ValidateAddressRequest city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required; City part of the addrerss to validate, such as 'Walnut Creek'")
    @JsonProperty(value="City")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public ValidateAddressRequest stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required; State or province of the address to validate, such as 'CA' or 'California'")
    @JsonProperty(value="StateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public ValidateAddressRequest postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional (recommended); Zip code or postal code of the address to validate, such as '94597'")
    @JsonProperty(value="PostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public ValidateAddressRequest countryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional (recommended); Name of the country, such as 'United States'.  If left blank, and CountryCode is also left blank, will default to United States.  Global countries are supported.")
    @JsonProperty(value="CountryFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryFullName() {
        return this.countryFullName;
    }

    public void setCountryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
    }

    public ValidateAddressRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; two-letter country code (Two-letter ISO 3166-1 country code) of the country.  If left blank, and CountryFullName is also left blank, will default to United States.  Global countries are supported.")
    @JsonProperty(value="CountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidateAddressRequest validateAddressRequest = (ValidateAddressRequest)o;
        return Objects.equals(this.streetAddress, validateAddressRequest.streetAddress) && Objects.equals(this.city, validateAddressRequest.city) && Objects.equals(this.stateOrProvince, validateAddressRequest.stateOrProvince) && Objects.equals(this.postalCode, validateAddressRequest.postalCode) && Objects.equals(this.countryFullName, validateAddressRequest.countryFullName) && Objects.equals(this.countryCode, validateAddressRequest.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.streetAddress, this.city, this.stateOrProvince, this.postalCode, this.countryFullName, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidateAddressRequest {\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryFullName: ").append(this.toIndentedString(this.countryFullName)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

