/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The result of a User-Agent validation request")
@JsonPropertyOrder(value={"Successful", "IsBot", "BotName", "BotURL", "OperatingSystem", "OperatingSystemCPUPlatform", "OperatingSystemVersion", "DeviceType", "DeviceBrandName", "DeviceModel", "BrowserName", "BrowserVersion", "BrowserEngineName", "BrowserEngineVersion"})
@JsonTypeName(value="UserAgentValidateResponse")
public class UserAgentValidateResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_IS_BOT = "IsBot";
    private Boolean isBot;
    public static final String JSON_PROPERTY_BOT_NAME = "BotName";
    private String botName;
    public static final String JSON_PROPERTY_BOT_U_R_L = "BotURL";
    private String botURL;
    public static final String JSON_PROPERTY_OPERATING_SYSTEM = "OperatingSystem";
    private String operatingSystem;
    public static final String JSON_PROPERTY_OPERATING_SYSTEM_C_P_U_PLATFORM = "OperatingSystemCPUPlatform";
    private String operatingSystemCPUPlatform;
    public static final String JSON_PROPERTY_OPERATING_SYSTEM_VERSION = "OperatingSystemVersion";
    private String operatingSystemVersion;
    public static final String JSON_PROPERTY_DEVICE_TYPE = "DeviceType";
    private String deviceType;
    public static final String JSON_PROPERTY_DEVICE_BRAND_NAME = "DeviceBrandName";
    private String deviceBrandName;
    public static final String JSON_PROPERTY_DEVICE_MODEL = "DeviceModel";
    private String deviceModel;
    public static final String JSON_PROPERTY_BROWSER_NAME = "BrowserName";
    private String browserName;
    public static final String JSON_PROPERTY_BROWSER_VERSION = "BrowserVersion";
    private String browserVersion;
    public static final String JSON_PROPERTY_BROWSER_ENGINE_NAME = "BrowserEngineName";
    private String browserEngineName;
    public static final String JSON_PROPERTY_BROWSER_ENGINE_VERSION = "BrowserEngineVersion";
    private String browserEngineVersion;

    public UserAgentValidateResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public UserAgentValidateResponse isBot(Boolean isBot) {
        this.isBot = isBot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the request is a known robot, false otherwise")
    @JsonProperty(value="IsBot")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsBot() {
        return this.isBot;
    }

    public void setIsBot(Boolean isBot) {
        this.isBot = isBot;
    }

    public UserAgentValidateResponse botName(String botName) {
        this.botName = botName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; name of the robot if the request was from a known robot, otherwise null")
    @JsonProperty(value="BotName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBotName() {
        return this.botName;
    }

    public void setBotName(String botName) {
        this.botName = botName;
    }

    public UserAgentValidateResponse botURL(String botURL) {
        this.botURL = botURL;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; if available, the URL to the robot")
    @JsonProperty(value="BotURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBotURL() {
        return this.botURL;
    }

    public void setBotURL(String botURL) {
        this.botURL = botURL;
    }

    public UserAgentValidateResponse operatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operating System of the User-Agent (e.g. Windows)")
    @JsonProperty(value="OperatingSystem")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public UserAgentValidateResponse operatingSystemCPUPlatform(String operatingSystemCPUPlatform) {
        this.operatingSystemCPUPlatform = operatingSystemCPUPlatform;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The CPU platform of the User-Agent (e.g. x64)")
    @JsonProperty(value="OperatingSystemCPUPlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOperatingSystemCPUPlatform() {
        return this.operatingSystemCPUPlatform;
    }

    public void setOperatingSystemCPUPlatform(String operatingSystemCPUPlatform) {
        this.operatingSystemCPUPlatform = operatingSystemCPUPlatform;
    }

    public UserAgentValidateResponse operatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version of the operating system of the User-Agent (e.g. \"10\" for Windows 10)")
    @JsonProperty(value="OperatingSystemVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public UserAgentValidateResponse deviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Device type of the User-Agent; possible values are \"DESKTOP\", \"SMARTPHONE\", \"TABLET\"")
    @JsonProperty(value="DeviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public UserAgentValidateResponse deviceBrandName(String deviceBrandName) {
        this.deviceBrandName = deviceBrandName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Brand name of the User-Agent")
    @JsonProperty(value="DeviceBrandName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceBrandName() {
        return this.deviceBrandName;
    }

    public void setDeviceBrandName(String deviceBrandName) {
        this.deviceBrandName = deviceBrandName;
    }

    public UserAgentValidateResponse deviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Model name or number of the User-Agent")
    @JsonProperty(value="DeviceModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public UserAgentValidateResponse browserName(String browserName) {
        this.browserName = browserName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the Browser")
    @JsonProperty(value="BrowserName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public UserAgentValidateResponse browserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version of the Browser")
    @JsonProperty(value="BrowserVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public UserAgentValidateResponse browserEngineName(String browserEngineName) {
        this.browserEngineName = browserEngineName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the Browser Engine")
    @JsonProperty(value="BrowserEngineName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrowserEngineName() {
        return this.browserEngineName;
    }

    public void setBrowserEngineName(String browserEngineName) {
        this.browserEngineName = browserEngineName;
    }

    public UserAgentValidateResponse browserEngineVersion(String browserEngineVersion) {
        this.browserEngineVersion = browserEngineVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version of the Browser Engine")
    @JsonProperty(value="BrowserEngineVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrowserEngineVersion() {
        return this.browserEngineVersion;
    }

    public void setBrowserEngineVersion(String browserEngineVersion) {
        this.browserEngineVersion = browserEngineVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgentValidateResponse userAgentValidateResponse = (UserAgentValidateResponse)o;
        return Objects.equals(this.successful, userAgentValidateResponse.successful) && Objects.equals(this.isBot, userAgentValidateResponse.isBot) && Objects.equals(this.botName, userAgentValidateResponse.botName) && Objects.equals(this.botURL, userAgentValidateResponse.botURL) && Objects.equals(this.operatingSystem, userAgentValidateResponse.operatingSystem) && Objects.equals(this.operatingSystemCPUPlatform, userAgentValidateResponse.operatingSystemCPUPlatform) && Objects.equals(this.operatingSystemVersion, userAgentValidateResponse.operatingSystemVersion) && Objects.equals(this.deviceType, userAgentValidateResponse.deviceType) && Objects.equals(this.deviceBrandName, userAgentValidateResponse.deviceBrandName) && Objects.equals(this.deviceModel, userAgentValidateResponse.deviceModel) && Objects.equals(this.browserName, userAgentValidateResponse.browserName) && Objects.equals(this.browserVersion, userAgentValidateResponse.browserVersion) && Objects.equals(this.browserEngineName, userAgentValidateResponse.browserEngineName) && Objects.equals(this.browserEngineVersion, userAgentValidateResponse.browserEngineVersion);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.isBot, this.botName, this.botURL, this.operatingSystem, this.operatingSystemCPUPlatform, this.operatingSystemVersion, this.deviceType, this.deviceBrandName, this.deviceModel, this.browserName, this.browserVersion, this.browserEngineName, this.browserEngineVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAgentValidateResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    isBot: ").append(this.toIndentedString(this.isBot)).append("\n");
        sb.append("    botName: ").append(this.toIndentedString(this.botName)).append("\n");
        sb.append("    botURL: ").append(this.toIndentedString(this.botURL)).append("\n");
        sb.append("    operatingSystem: ").append(this.toIndentedString(this.operatingSystem)).append("\n");
        sb.append("    operatingSystemCPUPlatform: ").append(this.toIndentedString(this.operatingSystemCPUPlatform)).append("\n");
        sb.append("    operatingSystemVersion: ").append(this.toIndentedString(this.operatingSystemVersion)).append("\n");
        sb.append("    deviceType: ").append(this.toIndentedString(this.deviceType)).append("\n");
        sb.append("    deviceBrandName: ").append(this.toIndentedString(this.deviceBrandName)).append("\n");
        sb.append("    deviceModel: ").append(this.toIndentedString(this.deviceModel)).append("\n");
        sb.append("    browserName: ").append(this.toIndentedString(this.browserName)).append("\n");
        sb.append("    browserVersion: ").append(this.toIndentedString(this.browserVersion)).append("\n");
        sb.append("    browserEngineName: ").append(this.toIndentedString(this.browserEngineName)).append("\n");
        sb.append("    browserEngineVersion: ").append(this.toIndentedString(this.browserEngineVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

