/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="IANA/Olsen time zone")
@JsonPropertyOrder(value={"Name", "BaseUTCOffset", "Now"})
@JsonTypeName(value="Timezone")
public class Timezone {
    public static final String JSON_PROPERTY_NAME = "Name";
    private String name;
    public static final String JSON_PROPERTY_BASE_U_T_C_OFFSET = "BaseUTCOffset";
    private String baseUTCOffset;
    public static final String JSON_PROPERTY_NOW = "Now";
    private OffsetDateTime now;

    public Timezone name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the Time Zone")
    @JsonProperty(value="Name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Timezone baseUTCOffset(String baseUTCOffset) {
        this.baseUTCOffset = baseUTCOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UTC offset for this time zone")
    @JsonProperty(value="BaseUTCOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseUTCOffset() {
        return this.baseUTCOffset;
    }

    public void setBaseUTCOffset(String baseUTCOffset) {
        this.baseUTCOffset = baseUTCOffset;
    }

    public Timezone now(OffsetDateTime now) {
        this.now = now;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current time (Now) in this time zone")
    @JsonProperty(value="Now")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getNow() {
        return this.now;
    }

    public void setNow(OffsetDateTime now) {
        this.now = now;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timezone timezone = (Timezone)o;
        return Objects.equals(this.name, timezone.name) && Objects.equals(this.baseUTCOffset, timezone.baseUTCOffset) && Objects.equals(this.now, timezone.now);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.baseUTCOffset, this.now);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Timezone {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    baseUTCOffset: ").append(this.toIndentedString(this.baseUTCOffset)).append("\n");
        sb.append("    now: ").append(this.toIndentedString(this.now)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

