/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Individual instance of text occuring in an image; one piece of text")
@JsonPropertyOrder(value={"LeftX", "TopY", "Width", "Height"})
@JsonTypeName(value="TextItem")
public class TextItem {
    public static final String JSON_PROPERTY_LEFT_X = "LeftX";
    private Integer leftX;
    public static final String JSON_PROPERTY_TOP_Y = "TopY";
    private Integer topY;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;

    public TextItem leftX(Integer leftX) {
        this.leftX = leftX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Left X coordinate of the text location; 0 represents the left edge of the input image")
    @JsonProperty(value="LeftX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLeftX() {
        return this.leftX;
    }

    public void setLeftX(Integer leftX) {
        this.leftX = leftX;
    }

    public TextItem topY(Integer topY) {
        this.topY = topY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Top Y coordinate of the text location; 0 represents the top edge of the input image")
    @JsonProperty(value="TopY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopY() {
        return this.topY;
    }

    public void setTopY(Integer topY) {
        this.topY = topY;
    }

    public TextItem width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width in pixels of the text item")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public TextItem height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height in pixels of the text item")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextItem textItem = (TextItem)o;
        return Objects.equals(this.leftX, textItem.leftX) && Objects.equals(this.topY, textItem.topY) && Objects.equals(this.width, textItem.width) && Objects.equals(this.height, textItem.height);
    }

    public int hashCode() {
        return Objects.hash(this.leftX, this.topY, this.width, this.height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextItem {\n");
        sb.append("    leftX: ").append(this.toIndentedString(this.leftX)).append("\n");
        sb.append("    topY: ").append(this.toIndentedString(this.topY)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

