/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.OcrPhotoTextElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The recognition result of one cell in one row in a table of a form")
@JsonPropertyOrder(value={"ColumnID", "CellValues"})
@JsonTypeName(value="TableCellResult")
public class TableCellResult {
    public static final String JSON_PROPERTY_COLUMN_I_D = "ColumnID";
    private String columnID;
    public static final String JSON_PROPERTY_CELL_VALUES = "CellValues";
    private List<OcrPhotoTextElement> cellValues = null;

    public TableCellResult columnID(String columnID) {
        this.columnID = columnID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the column")
    @JsonProperty(value="ColumnID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColumnID() {
        return this.columnID;
    }

    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    public TableCellResult cellValues(List<OcrPhotoTextElement> cellValues) {
        this.cellValues = cellValues;
        return this;
    }

    public TableCellResult addCellValuesItem(OcrPhotoTextElement cellValuesItem) {
        if (this.cellValues == null) {
            this.cellValues = new ArrayList<OcrPhotoTextElement>();
        }
        this.cellValues.add(cellValuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Result cell value(s) extracted")
    @JsonProperty(value="CellValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OcrPhotoTextElement> getCellValues() {
        return this.cellValues;
    }

    public void setCellValues(List<OcrPhotoTextElement> cellValues) {
        this.cellValues = cellValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableCellResult tableCellResult = (TableCellResult)o;
        return Objects.equals(this.columnID, tableCellResult.columnID) && Objects.equals(this.cellValues, tableCellResult.cellValues);
    }

    public int hashCode() {
        return Objects.hash(this.columnID, this.cellValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableCellResult {\n");
        sb.append("    columnID: ").append(this.toIndentedString(this.columnID)).append("\n");
        sb.append("    cellValues: ").append(this.toIndentedString(this.cellValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

