/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a subjectivity analysis operation")
@JsonPropertyOrder(value={"Successful", "SubjectivityScoreResult", "SentenceCount"})
@JsonTypeName(value="SubjectivityAnalysisResponse")
public class SubjectivityAnalysisResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_SUBJECTIVITY_SCORE_RESULT = "SubjectivityScoreResult";
    private Double subjectivityScoreResult;
    public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
    private Integer sentenceCount;

    public SubjectivityAnalysisResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the subjectivity analysis operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public SubjectivityAnalysisResponse subjectivityScoreResult(Double subjectivityScoreResult) {
        this.subjectivityScoreResult = subjectivityScoreResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subjectivity vs. objectivity classification score between 0.0 and 1.0 where scores closer to zero have a high probability of objectivity, while scores close to 1.0 have a high probability of subjectivity.")
    @JsonProperty(value="SubjectivityScoreResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSubjectivityScoreResult() {
        return this.subjectivityScoreResult;
    }

    public void setSubjectivityScoreResult(Double subjectivityScoreResult) {
        this.subjectivityScoreResult = subjectivityScoreResult;
    }

    public SubjectivityAnalysisResponse sentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of sentences in input text")
    @JsonProperty(value="SentenceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectivityAnalysisResponse subjectivityAnalysisResponse = (SubjectivityAnalysisResponse)o;
        return Objects.equals(this.successful, subjectivityAnalysisResponse.successful) && Objects.equals(this.subjectivityScoreResult, subjectivityAnalysisResponse.subjectivityScoreResult) && Objects.equals(this.sentenceCount, subjectivityAnalysisResponse.sentenceCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.subjectivityScoreResult, this.sentenceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubjectivityAnalysisResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    subjectivityScoreResult: ").append(this.toIndentedString(this.subjectivityScoreResult)).append("\n");
        sb.append("    sentenceCount: ").append(this.toIndentedString(this.sentenceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

