/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.PdfDocument;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a PDF file split operation")
@JsonPropertyOrder(value={"Successful", "Documents"})
@JsonTypeName(value="SplitPdfResult")
public class SplitPdfResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_DOCUMENTS = "Documents";
    private List<PdfDocument> documents = null;

    public SplitPdfResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public SplitPdfResult documents(List<PdfDocument> documents) {
        this.documents = documents;
        return this;
    }

    public SplitPdfResult addDocumentsItem(PdfDocument documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<PdfDocument>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PDF documents as output")
    @JsonProperty(value="Documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PdfDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<PdfDocument> documents) {
        this.documents = documents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitPdfResult splitPdfResult = (SplitPdfResult)o;
        return Objects.equals(this.successful, splitPdfResult.successful) && Objects.equals(this.documents, splitPdfResult.documents);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.documents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitPdfResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

