/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a similarity analysis operation")
@JsonPropertyOrder(value={"Successful", "SimilarityScoreResult", "SentenceCount"})
@JsonTypeName(value="SimilarityAnalysisResponse")
public class SimilarityAnalysisResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_SIMILARITY_SCORE_RESULT = "SimilarityScoreResult";
    private Double similarityScoreResult;
    public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
    private Integer sentenceCount;

    public SimilarityAnalysisResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the similarity analysis operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public SimilarityAnalysisResponse similarityScoreResult(Double similarityScoreResult) {
        this.similarityScoreResult = similarityScoreResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Similarity score between 0.0 and 1.0 where scores closer to zero have a low probability of semantic similarity, while scores close to 1.0 have a high probability of semantic similarity.")
    @JsonProperty(value="SimilarityScoreResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSimilarityScoreResult() {
        return this.similarityScoreResult;
    }

    public void setSimilarityScoreResult(Double similarityScoreResult) {
        this.similarityScoreResult = similarityScoreResult;
    }

    public SimilarityAnalysisResponse sentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of sentences in input text")
    @JsonProperty(value="SentenceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimilarityAnalysisResponse similarityAnalysisResponse = (SimilarityAnalysisResponse)o;
        return Objects.equals(this.successful, similarityAnalysisResponse.successful) && Objects.equals(this.similarityScoreResult, similarityAnalysisResponse.similarityScoreResult) && Objects.equals(this.sentenceCount, similarityAnalysisResponse.sentenceCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.similarityScoreResult, this.sentenceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimilarityAnalysisResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    similarityScoreResult: ").append(this.toIndentedString(this.similarityScoreResult)).append("\n");
        sb.append("    sentenceCount: ").append(this.toIndentedString(this.sentenceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

