/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.SetFormFieldValue;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to set the fields in a PDF form")
@JsonPropertyOrder(value={"FieldValues", "InputFileBytes"})
@JsonTypeName(value="SetPdfFormFieldsRequest")
public class SetPdfFormFieldsRequest {
    public static final String JSON_PROPERTY_FIELD_VALUES = "FieldValues";
    private List<SetFormFieldValue> fieldValues = null;
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;

    public SetPdfFormFieldsRequest fieldValues(List<SetFormFieldValue> fieldValues) {
        this.fieldValues = fieldValues;
        return this;
    }

    public SetPdfFormFieldsRequest addFieldValuesItem(SetFormFieldValue fieldValuesItem) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<SetFormFieldValue>();
        }
        this.fieldValues.add(fieldValuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Field values to set")
    @JsonProperty(value="FieldValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SetFormFieldValue> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(List<SetFormFieldValue> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public SetPdfFormFieldsRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contents of the input file to set the fields on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetPdfFormFieldsRequest setPdfFormFieldsRequest = (SetPdfFormFieldsRequest)o;
        return Objects.equals(this.fieldValues, setPdfFormFieldsRequest.fieldValues) && Arrays.equals(this.inputFileBytes, setPdfFormFieldsRequest.inputFileBytes);
    }

    public int hashCode() {
        return Objects.hash(this.fieldValues, Arrays.hashCode(this.inputFileBytes));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetPdfFormFieldsRequest {\n");
        sb.append("    fieldValues: ").append(this.toIndentedString(this.fieldValues)).append("\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

