/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Individual field value to set in a PDF form")
@JsonPropertyOrder(value={"FieldName", "TextValue", "CheckboxValue", "ComboBoxSelectedIndex"})
@JsonTypeName(value="SetFormFieldValue")
public class SetFormFieldValue {
    public static final String JSON_PROPERTY_FIELD_NAME = "FieldName";
    private String fieldName;
    public static final String JSON_PROPERTY_TEXT_VALUE = "TextValue";
    private String textValue;
    public static final String JSON_PROPERTY_CHECKBOX_VALUE = "CheckboxValue";
    private Boolean checkboxValue;
    public static final String JSON_PROPERTY_COMBO_BOX_SELECTED_INDEX = "ComboBoxSelectedIndex";
    private Integer comboBoxSelectedIndex;

    public SetFormFieldValue fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the field to set; you can call /convert/edit/pdf/form/get-fields to enumerate field names in a form")
    @JsonProperty(value="FieldName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public SetFormFieldValue textValue(String textValue) {
        this.textValue = textValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For fields of type Text, the text value to put into the field")
    @JsonProperty(value="TextValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public SetFormFieldValue checkboxValue(Boolean checkboxValue) {
        this.checkboxValue = checkboxValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For fields of type Checkbox, the value to put into the field")
    @JsonProperty(value="CheckboxValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCheckboxValue() {
        return this.checkboxValue;
    }

    public void setCheckboxValue(Boolean checkboxValue) {
        this.checkboxValue = checkboxValue;
    }

    public SetFormFieldValue comboBoxSelectedIndex(Integer comboBoxSelectedIndex) {
        this.comboBoxSelectedIndex = comboBoxSelectedIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For fields of type ComboBox; specifies the selected index of the combo box selection")
    @JsonProperty(value="ComboBoxSelectedIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getComboBoxSelectedIndex() {
        return this.comboBoxSelectedIndex;
    }

    public void setComboBoxSelectedIndex(Integer comboBoxSelectedIndex) {
        this.comboBoxSelectedIndex = comboBoxSelectedIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetFormFieldValue setFormFieldValue = (SetFormFieldValue)o;
        return Objects.equals(this.fieldName, setFormFieldValue.fieldName) && Objects.equals(this.textValue, setFormFieldValue.textValue) && Objects.equals(this.checkboxValue, setFormFieldValue.checkboxValue) && Objects.equals(this.comboBoxSelectedIndex, setFormFieldValue.comboBoxSelectedIndex);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.textValue, this.checkboxValue, this.comboBoxSelectedIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetFormFieldValue {\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    textValue: ").append(this.toIndentedString(this.textValue)).append("\n");
        sb.append("    checkboxValue: ").append(this.toIndentedString(this.checkboxValue)).append("\n");
        sb.append("    comboBoxSelectedIndex: ").append(this.toIndentedString(this.comboBoxSelectedIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

