/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details of the screenshot request")
@JsonPropertyOrder(value={"Url", "ExtraLoadingWait", "ScreenshotWidth", "ScreenshotHeight"})
@JsonTypeName(value="ScreenshotRequest")
public class ScreenshotRequest {
    public static final String JSON_PROPERTY_URL = "Url";
    private String url;
    public static final String JSON_PROPERTY_EXTRA_LOADING_WAIT = "ExtraLoadingWait";
    private Integer extraLoadingWait;
    public static final String JSON_PROPERTY_SCREENSHOT_WIDTH = "ScreenshotWidth";
    private Integer screenshotWidth;
    public static final String JSON_PROPERTY_SCREENSHOT_HEIGHT = "ScreenshotHeight";
    private Integer screenshotHeight;

    public ScreenshotRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL address of the website to screenshot.  HTTP and HTTPS are both supported, as are custom ports.")
    @JsonProperty(value="Url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ScreenshotRequest extraLoadingWait(Integer extraLoadingWait) {
        this.extraLoadingWait = extraLoadingWait;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Additional number of milliseconds to wait once the web page has finished loading before taking the screenshot.  Can be helpful for highly asynchronous websites.  Provide a value of 0 for the default of 5000 milliseconds (5 seconds). Maximum is 20000 milliseconds (20 seconds).")
    @JsonProperty(value="ExtraLoadingWait")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExtraLoadingWait() {
        return this.extraLoadingWait;
    }

    public void setExtraLoadingWait(Integer extraLoadingWait) {
        this.extraLoadingWait = extraLoadingWait;
    }

    public ScreenshotRequest screenshotWidth(Integer screenshotWidth) {
        this.screenshotWidth = screenshotWidth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Width of the screenshot in pixels; supply 0 to default to 1280 x 1024")
    @JsonProperty(value="ScreenshotWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getScreenshotWidth() {
        return this.screenshotWidth;
    }

    public void setScreenshotWidth(Integer screenshotWidth) {
        this.screenshotWidth = screenshotWidth;
    }

    public ScreenshotRequest screenshotHeight(Integer screenshotHeight) {
        this.screenshotHeight = screenshotHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Height of the screenshot in pixels; supply 0 to default to 1280 x 1024, supply -1 to measure the full screen height of the page and attempt to take a screen-height screenshot")
    @JsonProperty(value="ScreenshotHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getScreenshotHeight() {
        return this.screenshotHeight;
    }

    public void setScreenshotHeight(Integer screenshotHeight) {
        this.screenshotHeight = screenshotHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenshotRequest screenshotRequest = (ScreenshotRequest)o;
        return Objects.equals(this.url, screenshotRequest.url) && Objects.equals(this.extraLoadingWait, screenshotRequest.extraLoadingWait) && Objects.equals(this.screenshotWidth, screenshotRequest.screenshotWidth) && Objects.equals(this.screenshotHeight, screenshotRequest.screenshotHeight);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.extraLoadingWait, this.screenshotWidth, this.screenshotHeight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScreenshotRequest {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    extraLoadingWait: ").append(this.toIndentedString(this.extraLoadingWait)).append("\n");
        sb.append("    screenshotWidth: ").append(this.toIndentedString(this.screenshotWidth)).append("\n");
        sb.append("    screenshotHeight: ").append(this.toIndentedString(this.screenshotHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

