/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to replace a regex string in a string")
@JsonPropertyOrder(value={"TextContent", "RegularExpressionString", "ReplaceWithString"})
@JsonTypeName(value="ReplaceStringRegexRequest")
public class ReplaceStringRegexRequest {
    public static final String JSON_PROPERTY_TEXT_CONTENT = "TextContent";
    private String textContent;
    public static final String JSON_PROPERTY_REGULAR_EXPRESSION_STRING = "RegularExpressionString";
    private String regularExpressionString;
    public static final String JSON_PROPERTY_REPLACE_WITH_STRING = "ReplaceWithString";
    private String replaceWithString;

    public ReplaceStringRegexRequest textContent(String textContent) {
        this.textContent = textContent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Input text content")
    @JsonProperty(value="TextContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public ReplaceStringRegexRequest regularExpressionString(String regularExpressionString) {
        this.regularExpressionString = regularExpressionString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Target input regular expression (regex) string to match and be replaced; supports all regular expression values")
    @JsonProperty(value="RegularExpressionString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegularExpressionString() {
        return this.regularExpressionString;
    }

    public void setRegularExpressionString(String regularExpressionString) {
        this.regularExpressionString = regularExpressionString;
    }

    public ReplaceStringRegexRequest replaceWithString(String replaceWithString) {
        this.replaceWithString = replaceWithString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Replacement for target string; supports referencing indexed regex matched values from RegularExpressionString, such as $1, $2, and so on")
    @JsonProperty(value="ReplaceWithString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReplaceWithString() {
        return this.replaceWithString;
    }

    public void setReplaceWithString(String replaceWithString) {
        this.replaceWithString = replaceWithString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceStringRegexRequest replaceStringRegexRequest = (ReplaceStringRegexRequest)o;
        return Objects.equals(this.textContent, replaceStringRegexRequest.textContent) && Objects.equals(this.regularExpressionString, replaceStringRegexRequest.regularExpressionString) && Objects.equals(this.replaceWithString, replaceStringRegexRequest.replaceWithString);
    }

    public int hashCode() {
        return Objects.hash(this.textContent, this.regularExpressionString, this.replaceWithString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplaceStringRegexRequest {\n");
        sb.append("    textContent: ").append(this.toIndentedString(this.textContent)).append("\n");
        sb.append("    regularExpressionString: ").append(this.toIndentedString(this.regularExpressionString)).append("\n");
        sb.append("    replaceWithString: ").append(this.toIndentedString(this.replaceWithString)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

