/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.RephrasedSentence;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a text rephrasing operation")
@JsonPropertyOrder(value={"Successful", "RephrasedResults", "SentenceCount"})
@JsonTypeName(value="RephraseResponse")
public class RephraseResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_REPHRASED_RESULTS = "RephrasedResults";
    private List<RephrasedSentence> rephrasedResults = null;
    public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
    private Integer sentenceCount;

    public RephraseResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the language detection operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public RephraseResponse rephrasedResults(List<RephrasedSentence> rephrasedResults) {
        this.rephrasedResults = rephrasedResults;
        return this;
    }

    public RephraseResponse addRephrasedResultsItem(RephrasedSentence rephrasedResultsItem) {
        if (this.rephrasedResults == null) {
            this.rephrasedResults = new ArrayList<RephrasedSentence>();
        }
        this.rephrasedResults.add(rephrasedResultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Results of the rephrasing, paraphrasing operation, in the order of the input sentences")
    @JsonProperty(value="RephrasedResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RephrasedSentence> getRephrasedResults() {
        return this.rephrasedResults;
    }

    public void setRephrasedResults(List<RephrasedSentence> rephrasedResults) {
        this.rephrasedResults = rephrasedResults;
    }

    public RephraseResponse sentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of sentences in input text")
    @JsonProperty(value="SentenceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RephraseResponse rephraseResponse = (RephraseResponse)o;
        return Objects.equals(this.successful, rephraseResponse.successful) && Objects.equals(this.rephrasedResults, rephraseResponse.rephrasedResults) && Objects.equals(this.sentenceCount, rephraseResponse.sentenceCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.rephrasedResults, this.sentenceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RephraseResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    rephrasedResults: ").append(this.toIndentedString(this.rephrasedResults)).append("\n");
        sb.append("    sentenceCount: ").append(this.toIndentedString(this.sentenceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

