/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a text rephrasing operation")
@JsonPropertyOrder(value={"TextToTranslate", "TargetRephrasingCount"})
@JsonTypeName(value="RephraseRequest")
public class RephraseRequest {
    public static final String JSON_PROPERTY_TEXT_TO_TRANSLATE = "TextToTranslate";
    private String textToTranslate;
    public static final String JSON_PROPERTY_TARGET_REPHRASING_COUNT = "TargetRephrasingCount";
    private Integer targetRephrasingCount;

    public RephraseRequest textToTranslate(String textToTranslate) {
        this.textToTranslate = textToTranslate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text to rephrase")
    @JsonProperty(value="TextToTranslate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextToTranslate() {
        return this.textToTranslate;
    }

    public void setTextToTranslate(String textToTranslate) {
        this.textToTranslate = textToTranslate;
    }

    public RephraseRequest targetRephrasingCount(Integer targetRephrasingCount) {
        this.targetRephrasingCount = targetRephrasingCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of rephrasing output options you would like per sentence; possible values are 1 to 10.  Default is 2.")
    @JsonProperty(value="TargetRephrasingCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTargetRephrasingCount() {
        return this.targetRephrasingCount;
    }

    public void setTargetRephrasingCount(Integer targetRephrasingCount) {
        this.targetRephrasingCount = targetRephrasingCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RephraseRequest rephraseRequest = (RephraseRequest)o;
        return Objects.equals(this.textToTranslate, rephraseRequest.textToTranslate) && Objects.equals(this.targetRephrasingCount, rephraseRequest.targetRephrasingCount);
    }

    public int hashCode() {
        return Objects.hash(this.textToTranslate, this.targetRephrasingCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RephraseRequest {\n");
        sb.append("    textToTranslate: ").append(this.toIndentedString(this.textToTranslate)).append("\n");
        sb.append("    targetRephrasingCount: ").append(this.toIndentedString(this.targetRephrasingCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

