/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.XlsxWorksheet;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Rename-Worksheet request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "WorksheetToRename", "NewWorksheetName"})
@JsonTypeName(value="RenameXlsxWorksheetRequest")
public class RenameXlsxWorksheetRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_WORKSHEET_TO_RENAME = "WorksheetToRename";
    private XlsxWorksheet worksheetToRename;
    public static final String JSON_PROPERTY_NEW_WORKSHEET_NAME = "NewWorksheetName";
    private String newWorksheetName;

    public RenameXlsxWorksheetRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public RenameXlsxWorksheetRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public RenameXlsxWorksheetRequest worksheetToRename(XlsxWorksheet worksheetToRename) {
        this.worksheetToRename = worksheetToRename;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="WorksheetToRename")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public XlsxWorksheet getWorksheetToRename() {
        return this.worksheetToRename;
    }

    public void setWorksheetToRename(XlsxWorksheet worksheetToRename) {
        this.worksheetToRename = worksheetToRename;
    }

    public RenameXlsxWorksheetRequest newWorksheetName(String newWorksheetName) {
        this.newWorksheetName = newWorksheetName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required; The new name to be used for the worksheet")
    @JsonProperty(value="NewWorksheetName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNewWorksheetName() {
        return this.newWorksheetName;
    }

    public void setNewWorksheetName(String newWorksheetName) {
        this.newWorksheetName = newWorksheetName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameXlsxWorksheetRequest renameXlsxWorksheetRequest = (RenameXlsxWorksheetRequest)o;
        return Arrays.equals(this.inputFileBytes, renameXlsxWorksheetRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, renameXlsxWorksheetRequest.inputFileUrl) && Objects.equals(this.worksheetToRename, renameXlsxWorksheetRequest.worksheetToRename) && Objects.equals(this.newWorksheetName, renameXlsxWorksheetRequest.newWorksheetName);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.worksheetToRename, this.newWorksheetName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RenameXlsxWorksheetRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    worksheetToRename: ").append(this.toIndentedString(this.worksheetToRename)).append("\n");
        sb.append("    newWorksheetName: ").append(this.toIndentedString(this.newWorksheetName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

