/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single Excel XLSX file corresponding to one worksheet (tab) in the original spreadsheet")
@JsonPropertyOrder(value={"SlideNumber", "URL", "PresentationContents"})
@JsonTypeName(value="PresentationResult")
public class PresentationResult {
    public static final String JSON_PROPERTY_SLIDE_NUMBER = "SlideNumber";
    private Integer slideNumber;
    public static final String JSON_PROPERTY_U_R_L = "URL";
    private String URL;
    public static final String JSON_PROPERTY_PRESENTATION_CONTENTS = "PresentationContents";
    private byte[] presentationContents;

    public PresentationResult slideNumber(Integer slideNumber) {
        this.slideNumber = slideNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Worksheet number of the converted page, starting with 1 for the left-most worksheet")
    @JsonProperty(value="SlideNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSlideNumber() {
        return this.slideNumber;
    }

    public void setSlideNumber(Integer slideNumber) {
        this.slideNumber = slideNumber;
    }

    public PresentationResult URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to the PPTX file of this slide; file is stored in an in-memory cache and will be deleted")
    @JsonProperty(value="URL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public PresentationResult presentationContents(byte[] presentationContents) {
        this.presentationContents = presentationContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contents of the presentation in bytes")
    @JsonProperty(value="PresentationContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getPresentationContents() {
        return this.presentationContents;
    }

    public void setPresentationContents(byte[] presentationContents) {
        this.presentationContents = presentationContents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentationResult presentationResult = (PresentationResult)o;
        return Objects.equals(this.slideNumber, presentationResult.slideNumber) && Objects.equals(this.URL, presentationResult.URL) && Arrays.equals(this.presentationContents, presentationResult.presentationContents);
    }

    public int hashCode() {
        return Objects.hash(this.slideNumber, this.URL, Arrays.hashCode(this.presentationContents));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresentationResult {\n");
        sb.append("    slideNumber: ").append(this.toIndentedString(this.slideNumber)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("    presentationContents: ").append(this.toIndentedString(this.presentationContents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

