/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Word tagged in a POS tag")
@JsonPropertyOrder(value={"Word", "Tag"})
@JsonTypeName(value="PosTaggedWord")
public class PosTaggedWord {
    public static final String JSON_PROPERTY_WORD = "Word";
    private Object word;
    public static final String JSON_PROPERTY_TAG = "Tag";
    private Object tag;

    public PosTaggedWord word(Object word) {
        this.word = word;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Word that was tagged")
    @JsonProperty(value="Word")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getWord() {
        return this.word;
    }

    public void setWord(Object word) {
        this.word = word;
    }

    public PosTaggedWord tag(Object tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Penn Treebank tag applied to the word")
    @JsonProperty(value="Tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PosTaggedWord posTaggedWord = (PosTaggedWord)o;
        return Objects.equals(this.word, posTaggedWord.word) && Objects.equals(this.tag, posTaggedWord.tag);
    }

    public int hashCode() {
        return Objects.hash(this.word, this.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PosTaggedWord {\n");
        sb.append("    word: ").append(this.toIndentedString(this.word)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

