/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Point location in 2D in an image, where 0, 0 represents the top/left corner of the image")
@JsonPropertyOrder(value={"X", "Y"})
@JsonTypeName(value="Point")
public class Point {
    public static final String JSON_PROPERTY_X = "X";
    private Integer X;
    public static final String JSON_PROPERTY_Y = "Y";
    private Integer Y;

    public Point X(Integer X) {
        this.X = X;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X location in 2D in the image, where 0 represents the left edge of the image")
    @JsonProperty(value="X")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getX() {
        return this.X;
    }

    public void setX(Integer X) {
        this.X = X;
    }

    public Point Y(Integer Y) {
        this.Y = Y;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y location in 2D in the image, where 0 represents the top edge of the image")
    @JsonProperty(value="Y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getY() {
        return this.Y;
    }

    public void setY(Integer Y) {
        this.Y = Y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        return Objects.equals(this.X, point.X) && Objects.equals(this.Y, point.Y);
    }

    public int hashCode() {
        return Objects.hash(this.X, this.Y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Point {\n");
        sb.append("    X: ").append(this.toIndentedString(this.X)).append("\n");
        sb.append("    Y: ").append(this.toIndentedString(this.Y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

