/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result from validating a phone number")
@JsonPropertyOrder(value={"IsValid", "Successful", "PhoneNumberType", "E164Format", "InternationalFormat", "NationalFormat", "CountryCode", "CountryName"})
@JsonTypeName(value="PhoneNumberValidationResponse")
public class PhoneNumberValidationResponse {
    public static final String JSON_PROPERTY_IS_VALID = "IsValid";
    private Boolean isValid;
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_PHONE_NUMBER_TYPE = "PhoneNumberType";
    private String phoneNumberType;
    public static final String JSON_PROPERTY_E164_FORMAT = "E164Format";
    private String e164Format;
    public static final String JSON_PROPERTY_INTERNATIONAL_FORMAT = "InternationalFormat";
    private String internationalFormat;
    public static final String JSON_PROPERTY_NATIONAL_FORMAT = "NationalFormat";
    private String nationalFormat;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_COUNTRY_NAME = "CountryName";
    private String countryName;

    public PhoneNumberValidationResponse isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the phone number is valid, false otherwise")
    @JsonProperty(value="IsValid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public PhoneNumberValidationResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false if there was an error during validation.  See IsValid for validation result.")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public PhoneNumberValidationResponse phoneNumberType(String phoneNumberType) {
        this.phoneNumberType = phoneNumberType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of phone number; possible values are: FixedLine, Mobile, FixedLineOrMobile, TollFree, PremiumRate,   SharedCost, Voip, PersonalNumber, Pager, Uan, Voicemail, Unknown")
    @JsonProperty(value="PhoneNumberType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public void setPhoneNumberType(String phoneNumberType) {
        this.phoneNumberType = phoneNumberType;
    }

    public PhoneNumberValidationResponse e164Format(String e164Format) {
        this.e164Format = e164Format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="E.164 format of the phone number")
    @JsonProperty(value="E164Format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE164Format() {
        return this.e164Format;
    }

    public void setE164Format(String e164Format) {
        this.e164Format = e164Format;
    }

    public PhoneNumberValidationResponse internationalFormat(String internationalFormat) {
        this.internationalFormat = internationalFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Internaltional format of the phone number")
    @JsonProperty(value="InternationalFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInternationalFormat() {
        return this.internationalFormat;
    }

    public void setInternationalFormat(String internationalFormat) {
        this.internationalFormat = internationalFormat;
    }

    public PhoneNumberValidationResponse nationalFormat(String nationalFormat) {
        this.nationalFormat = nationalFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="National format of the phone number")
    @JsonProperty(value="NationalFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationalFormat() {
        return this.nationalFormat;
    }

    public void setNationalFormat(String nationalFormat) {
        this.nationalFormat = nationalFormat;
    }

    public PhoneNumberValidationResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two digit country code of the phone number")
    @JsonProperty(value="CountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PhoneNumberValidationResponse countryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User-friendly long name of the country for the phone number")
    @JsonProperty(value="CountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumberValidationResponse phoneNumberValidationResponse = (PhoneNumberValidationResponse)o;
        return Objects.equals(this.isValid, phoneNumberValidationResponse.isValid) && Objects.equals(this.successful, phoneNumberValidationResponse.successful) && Objects.equals(this.phoneNumberType, phoneNumberValidationResponse.phoneNumberType) && Objects.equals(this.e164Format, phoneNumberValidationResponse.e164Format) && Objects.equals(this.internationalFormat, phoneNumberValidationResponse.internationalFormat) && Objects.equals(this.nationalFormat, phoneNumberValidationResponse.nationalFormat) && Objects.equals(this.countryCode, phoneNumberValidationResponse.countryCode) && Objects.equals(this.countryName, phoneNumberValidationResponse.countryName);
    }

    public int hashCode() {
        return Objects.hash(this.isValid, this.successful, this.phoneNumberType, this.e164Format, this.internationalFormat, this.nationalFormat, this.countryCode, this.countryName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneNumberValidationResponse {\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.isValid)).append("\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    phoneNumberType: ").append(this.toIndentedString(this.phoneNumberType)).append("\n");
        sb.append("    e164Format: ").append(this.toIndentedString(this.e164Format)).append("\n");
        sb.append("    internationalFormat: ").append(this.toIndentedString(this.internationalFormat)).append("\n");
        sb.append("    nationalFormat: ").append(this.toIndentedString(this.nationalFormat)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    countryName: ").append(this.toIndentedString(this.countryName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

