/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.Face;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A person identified in an image age classification operation")
@JsonPropertyOrder(value={"FaceLocation", "AgeClassificationConfidence", "AgeClass", "Age"})
@JsonTypeName(value="PersonWithAge")
public class PersonWithAge {
    public static final String JSON_PROPERTY_FACE_LOCATION = "FaceLocation";
    private Face faceLocation;
    public static final String JSON_PROPERTY_AGE_CLASSIFICATION_CONFIDENCE = "AgeClassificationConfidence";
    private Double ageClassificationConfidence;
    public static final String JSON_PROPERTY_AGE_CLASS = "AgeClass";
    private String ageClass;
    public static final String JSON_PROPERTY_AGE = "Age";
    private Double age;

    public PersonWithAge faceLocation(Face faceLocation) {
        this.faceLocation = faceLocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="FaceLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Face getFaceLocation() {
        return this.faceLocation;
    }

    public void setFaceLocation(Face faceLocation) {
        this.faceLocation = faceLocation;
    }

    public PersonWithAge ageClassificationConfidence(Double ageClassificationConfidence) {
        this.ageClassificationConfidence = ageClassificationConfidence;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence level of age classification; possible values are between 0.0 and 1.0; higher is better, with values &gt; 0.50 being high confidence results")
    @JsonProperty(value="AgeClassificationConfidence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getAgeClassificationConfidence() {
        return this.ageClassificationConfidence;
    }

    public void setAgeClassificationConfidence(Double ageClassificationConfidence) {
        this.ageClassificationConfidence = ageClassificationConfidence;
    }

    public PersonWithAge ageClass(String ageClass) {
        this.ageClass = ageClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's age range classification result in years; possible values are \"0-2\", \"4-6\", \"8-13\", \"15-20\", \"25-32\", \"38-43\", \"48-53\", \"60+\"")
    @JsonProperty(value="AgeClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAgeClass() {
        return this.ageClass;
    }

    public void setAgeClass(String ageClass) {
        this.ageClass = ageClass;
    }

    public PersonWithAge age(Double age) {
        this.age = age;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="Age")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getAge() {
        return this.age;
    }

    public void setAge(Double age) {
        this.age = age;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonWithAge personWithAge = (PersonWithAge)o;
        return Objects.equals(this.faceLocation, personWithAge.faceLocation) && Objects.equals(this.ageClassificationConfidence, personWithAge.ageClassificationConfidence) && Objects.equals(this.ageClass, personWithAge.ageClass) && Objects.equals(this.age, personWithAge.age);
    }

    public int hashCode() {
        return Objects.hash(this.faceLocation, this.ageClassificationConfidence, this.ageClass, this.age);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonWithAge {\n");
        sb.append("    faceLocation: ").append(this.toIndentedString(this.faceLocation)).append("\n");
        sb.append("    ageClassificationConfidence: ").append(this.toIndentedString(this.ageClassificationConfidence)).append("\n");
        sb.append("    ageClass: ").append(this.toIndentedString(this.ageClass)).append("\n");
        sb.append("    age: ").append(this.toIndentedString(this.age)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

