/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Text of a single page of a PDF")
@JsonPropertyOrder(value={"PageNumber", "PageText"})
@JsonTypeName(value="PdfPageText")
public class PdfPageText {
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_PAGE_TEXT = "PageText";
    private String pageText;

    public PdfPageText pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number of the page (1-based)")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public PdfPageText pageText(String pageText) {
        this.pageText = pageText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text of the page")
    @JsonProperty(value="PageText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageText() {
        return this.pageText;
    }

    public void setPageText(String pageText) {
        this.pageText = pageText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfPageText pdfPageText = (PdfPageText)o;
        return Objects.equals(this.pageNumber, pdfPageText.pageNumber) && Objects.equals(this.pageText, pdfPageText.pageText);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.pageText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfPageText {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageText: ").append(this.toIndentedString(this.pageText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

