/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="PDF Annotation details")
@JsonPropertyOrder(value={"Title", "AnnotationType", "PageNumber", "AnnotationIndex", "Subject", "TextContents", "CreationDate", "ModifiedDate", "LeftX", "TopY", "Width", "Height"})
@JsonTypeName(value="PdfAnnotation")
public class PdfAnnotation {
    public static final String JSON_PROPERTY_TITLE = "Title";
    private String title;
    public static final String JSON_PROPERTY_ANNOTATION_TYPE = "AnnotationType";
    private String annotationType;
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_ANNOTATION_INDEX = "AnnotationIndex";
    private Integer annotationIndex;
    public static final String JSON_PROPERTY_SUBJECT = "Subject";
    private String subject;
    public static final String JSON_PROPERTY_TEXT_CONTENTS = "TextContents";
    private String textContents;
    public static final String JSON_PROPERTY_CREATION_DATE = "CreationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_MODIFIED_DATE = "ModifiedDate";
    private OffsetDateTime modifiedDate;
    public static final String JSON_PROPERTY_LEFT_X = "LeftX";
    private Double leftX;
    public static final String JSON_PROPERTY_TOP_Y = "TopY";
    private Double topY;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Double width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Double height;

    public PdfAnnotation title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the annotation; this is often the author of the annotation in Acrobat-created PDF files")
    @JsonProperty(value="Title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public PdfAnnotation annotationType(String annotationType) {
        this.annotationType = annotationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the annotation; possible values are Text")
    @JsonProperty(value="AnnotationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public PdfAnnotation pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 1-based index of the page containing the annotation")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public PdfAnnotation annotationIndex(Integer annotationIndex) {
        this.annotationIndex = annotationIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 0-based index of the annotation in the document")
    @JsonProperty(value="AnnotationIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAnnotationIndex() {
        return this.annotationIndex;
    }

    public void setAnnotationIndex(Integer annotationIndex) {
        this.annotationIndex = annotationIndex;
    }

    public PdfAnnotation subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subject of the annotation")
    @JsonProperty(value="Subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public PdfAnnotation textContents(String textContents) {
        this.textContents = textContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text contents of the annotation")
    @JsonProperty(value="TextContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextContents() {
        return this.textContents;
    }

    public void setTextContents(String textContents) {
        this.textContents = textContents;
    }

    public PdfAnnotation creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date that the annotation was created")
    @JsonProperty(value="CreationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public PdfAnnotation modifiedDate(OffsetDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date that the annotation was last modified")
    @JsonProperty(value="ModifiedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(OffsetDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public PdfAnnotation leftX(Double leftX) {
        this.leftX = leftX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Left X coordinate for the location of the annotation")
    @JsonProperty(value="LeftX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLeftX() {
        return this.leftX;
    }

    public void setLeftX(Double leftX) {
        this.leftX = leftX;
    }

    public PdfAnnotation topY(Double topY) {
        this.topY = topY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Top Y coordination of the location of the annotation")
    @JsonProperty(value="TopY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTopY() {
        return this.topY;
    }

    public void setTopY(Double topY) {
        this.topY = topY;
    }

    public PdfAnnotation width(Double width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width of the annotation")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public PdfAnnotation height(Double height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height of the annotation")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfAnnotation pdfAnnotation = (PdfAnnotation)o;
        return Objects.equals(this.title, pdfAnnotation.title) && Objects.equals(this.annotationType, pdfAnnotation.annotationType) && Objects.equals(this.pageNumber, pdfAnnotation.pageNumber) && Objects.equals(this.annotationIndex, pdfAnnotation.annotationIndex) && Objects.equals(this.subject, pdfAnnotation.subject) && Objects.equals(this.textContents, pdfAnnotation.textContents) && Objects.equals(this.creationDate, pdfAnnotation.creationDate) && Objects.equals(this.modifiedDate, pdfAnnotation.modifiedDate) && Objects.equals(this.leftX, pdfAnnotation.leftX) && Objects.equals(this.topY, pdfAnnotation.topY) && Objects.equals(this.width, pdfAnnotation.width) && Objects.equals(this.height, pdfAnnotation.height);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.annotationType, this.pageNumber, this.annotationIndex, this.subject, this.textContents, this.creationDate, this.modifiedDate, this.leftX, this.topY, this.width, this.height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfAnnotation {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    annotationType: ").append(this.toIndentedString(this.annotationType)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    annotationIndex: ").append(this.toIndentedString(this.annotationIndex)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    textContents: ").append(this.toIndentedString(this.textContents)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    leftX: ").append(this.toIndentedString(this.leftX)).append("\n");
        sb.append("    topY: ").append(this.toIndentedString(this.topY)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

