/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of parsing an address into its component parts")
@JsonPropertyOrder(value={"Successful", "Building", "StreetNumber", "Street", "City", "StateOrProvince", "PostalCode", "CountryFullName", "ISOTwoLetterCode"})
@JsonTypeName(value="ParseAddressResponse")
public class ParseAddressResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_BUILDING = "Building";
    private String building;
    public static final String JSON_PROPERTY_STREET_NUMBER = "StreetNumber";
    private String streetNumber;
    public static final String JSON_PROPERTY_STREET = "Street";
    private String street;
    public static final String JSON_PROPERTY_CITY = "City";
    private String city;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "StateOrProvince";
    private String stateOrProvince;
    public static final String JSON_PROPERTY_POSTAL_CODE = "PostalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTRY_FULL_NAME = "CountryFullName";
    private String countryFullName;
    public static final String JSON_PROPERTY_IS_O_TWO_LETTER_CODE = "ISOTwoLetterCode";
    private String isOTwoLetterCode;

    public ParseAddressResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the parsing operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ParseAddressResponse building(String building) {
        this.building = building;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the building, house or structure if applicable, such as \"Cloudmersive Building 2\".  This will often by null.")
    @JsonProperty(value="Building")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public ParseAddressResponse streetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The street number or house number of the address.  For example, in the address \"1600 Pennsylvania Avenue NW\" the street number would be \"1600\".  This value will typically be populated for most addresses.")
    @JsonProperty(value="StreetNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public ParseAddressResponse street(String street) {
        this.street = street;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the street or road of the address.  For example, in the address \"1600 Pennsylvania Avenue NW\" the street number would be \"Pennsylvania Avenue NW\".")
    @JsonProperty(value="Street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public ParseAddressResponse city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The city of the address.")
    @JsonProperty(value="City")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public ParseAddressResponse stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state or province of the address.")
    @JsonProperty(value="StateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public ParseAddressResponse postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal code or zip code of the address.")
    @JsonProperty(value="PostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public ParseAddressResponse countryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country of the address, if present in the address.  If not included in the address it will be null.")
    @JsonProperty(value="CountryFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryFullName() {
        return this.countryFullName;
    }

    public void setCountryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
    }

    public ParseAddressResponse isOTwoLetterCode(String isOTwoLetterCode) {
        this.isOTwoLetterCode = isOTwoLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two-letter ISO 3166-1 country code")
    @JsonProperty(value="ISOTwoLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsOTwoLetterCode() {
        return this.isOTwoLetterCode;
    }

    public void setIsOTwoLetterCode(String isOTwoLetterCode) {
        this.isOTwoLetterCode = isOTwoLetterCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParseAddressResponse parseAddressResponse = (ParseAddressResponse)o;
        return Objects.equals(this.successful, parseAddressResponse.successful) && Objects.equals(this.building, parseAddressResponse.building) && Objects.equals(this.streetNumber, parseAddressResponse.streetNumber) && Objects.equals(this.street, parseAddressResponse.street) && Objects.equals(this.city, parseAddressResponse.city) && Objects.equals(this.stateOrProvince, parseAddressResponse.stateOrProvince) && Objects.equals(this.postalCode, parseAddressResponse.postalCode) && Objects.equals(this.countryFullName, parseAddressResponse.countryFullName) && Objects.equals(this.isOTwoLetterCode, parseAddressResponse.isOTwoLetterCode);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.building, this.streetNumber, this.street, this.city, this.stateOrProvince, this.postalCode, this.countryFullName, this.isOTwoLetterCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParseAddressResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    building: ").append(this.toIndentedString(this.building)).append("\n");
        sb.append("    streetNumber: ").append(this.toIndentedString(this.streetNumber)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryFullName: ").append(this.toIndentedString(this.countryFullName)).append("\n");
        sb.append("    isOTwoLetterCode: ").append(this.toIndentedString(this.isOTwoLetterCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

