/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.Point;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single text in an OCR document")
@JsonPropertyOrder(value={"Text", "XLeft", "YTop", "Width", "Height", "BoundingPoints", "ConfidenceLevel"})
@JsonTypeName(value="OcrPhotoTextElement")
public class OcrPhotoTextElement {
    public static final String JSON_PROPERTY_TEXT = "Text";
    private String text;
    public static final String JSON_PROPERTY_XLEFT = "XLeft";
    private Integer xleft;
    public static final String JSON_PROPERTY_YTOP = "YTop";
    private Integer ytop;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_BOUNDING_POINTS = "BoundingPoints";
    private List<Point> boundingPoints = null;
    public static final String JSON_PROPERTY_CONFIDENCE_LEVEL = "ConfidenceLevel";
    private Double confidenceLevel;

    public OcrPhotoTextElement text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text of the word")
    @JsonProperty(value="Text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public OcrPhotoTextElement xleft(Integer xleft) {
        this.xleft = xleft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X location of the left edge of the word in pixels")
    @JsonProperty(value="XLeft")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getXleft() {
        return this.xleft;
    }

    public void setXleft(Integer xleft) {
        this.xleft = xleft;
    }

    public OcrPhotoTextElement ytop(Integer ytop) {
        this.ytop = ytop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y location of the top edge of the word in pixels")
    @JsonProperty(value="YTop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getYtop() {
        return this.ytop;
    }

    public void setYtop(Integer ytop) {
        this.ytop = ytop;
    }

    public OcrPhotoTextElement width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width of the word in pixels")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public OcrPhotoTextElement height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height of the word in pixels")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public OcrPhotoTextElement boundingPoints(List<Point> boundingPoints) {
        this.boundingPoints = boundingPoints;
        return this;
    }

    public OcrPhotoTextElement addBoundingPointsItem(Point boundingPointsItem) {
        if (this.boundingPoints == null) {
            this.boundingPoints = new ArrayList<Point>();
        }
        this.boundingPoints.add(boundingPointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Points that form the bounding polygon around the text")
    @JsonProperty(value="BoundingPoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Point> getBoundingPoints() {
        return this.boundingPoints;
    }

    public void setBoundingPoints(List<Point> boundingPoints) {
        this.boundingPoints = boundingPoints;
    }

    public OcrPhotoTextElement confidenceLevel(Double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence level of the machine learning result; possible values are 0.0 (lowest accuracy) - 1.0 (highest accuracy)")
    @JsonProperty(value="ConfidenceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(Double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OcrPhotoTextElement ocrPhotoTextElement = (OcrPhotoTextElement)o;
        return Objects.equals(this.text, ocrPhotoTextElement.text) && Objects.equals(this.xleft, ocrPhotoTextElement.xleft) && Objects.equals(this.ytop, ocrPhotoTextElement.ytop) && Objects.equals(this.width, ocrPhotoTextElement.width) && Objects.equals(this.height, ocrPhotoTextElement.height) && Objects.equals(this.boundingPoints, ocrPhotoTextElement.boundingPoints) && Objects.equals(this.confidenceLevel, ocrPhotoTextElement.confidenceLevel);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.xleft, this.ytop, this.width, this.height, this.boundingPoints, this.confidenceLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OcrPhotoTextElement {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    xleft: ").append(this.toIndentedString(this.xleft)).append("\n");
        sb.append("    ytop: ").append(this.toIndentedString(this.ytop)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    boundingPoints: ").append(this.toIndentedString(this.boundingPoints)).append("\n");
        sb.append("    confidenceLevel: ").append(this.toIndentedString(this.confidenceLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

