/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.OcrLineElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="OCR results of a page, including lines of text and their location")
@JsonPropertyOrder(value={"PageNumber", "Successful", "Lines"})
@JsonTypeName(value="OcrPageResultWithLinesWithLocation")
public class OcrPageResultWithLinesWithLocation {
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_LINES = "Lines";
    private List<OcrLineElement> lines = null;

    public OcrPageResultWithLinesWithLocation pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number of the page that was OCR-ed, starting with 1 for the first page in the PDF file")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public OcrPageResultWithLinesWithLocation successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public OcrPageResultWithLinesWithLocation lines(List<OcrLineElement> lines) {
        this.lines = lines;
        return this;
    }

    public OcrPageResultWithLinesWithLocation addLinesItem(OcrLineElement linesItem) {
        if (this.lines == null) {
            this.lines = new ArrayList<OcrLineElement>();
        }
        this.lines.add(linesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Word elements in the image")
    @JsonProperty(value="Lines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OcrLineElement> getLines() {
        return this.lines;
    }

    public void setLines(List<OcrLineElement> lines) {
        this.lines = lines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OcrPageResultWithLinesWithLocation ocrPageResultWithLinesWithLocation = (OcrPageResultWithLinesWithLocation)o;
        return Objects.equals(this.pageNumber, ocrPageResultWithLinesWithLocation.pageNumber) && Objects.equals(this.successful, ocrPageResultWithLinesWithLocation.successful) && Objects.equals(this.lines, ocrPageResultWithLinesWithLocation.lines);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.successful, this.lines);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OcrPageResultWithLinesWithLocation {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    lines: ").append(this.toIndentedString(this.lines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

