/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"PageNumber", "MeanConfidenceLevel", "TextResult"})
@JsonTypeName(value="OcrPageResult")
public class OcrPageResult {
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_MEAN_CONFIDENCE_LEVEL = "MeanConfidenceLevel";
    private Float meanConfidenceLevel;
    public static final String JSON_PROPERTY_TEXT_RESULT = "TextResult";
    private String textResult;

    public OcrPageResult pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number of the page that was OCR-ed, starting with 1 for the first page in the PDF file")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public OcrPageResult meanConfidenceLevel(Float meanConfidenceLevel) {
        this.meanConfidenceLevel = meanConfidenceLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence level rating of the OCR operation; ratings above 80% are strong.")
    @JsonProperty(value="MeanConfidenceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getMeanConfidenceLevel() {
        return this.meanConfidenceLevel;
    }

    public void setMeanConfidenceLevel(Float meanConfidenceLevel) {
        this.meanConfidenceLevel = meanConfidenceLevel;
    }

    public OcrPageResult textResult(String textResult) {
        this.textResult = textResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Converted text string from the image input.")
    @JsonProperty(value="TextResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextResult() {
        return this.textResult;
    }

    public void setTextResult(String textResult) {
        this.textResult = textResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OcrPageResult ocrPageResult = (OcrPageResult)o;
        return Objects.equals(this.pageNumber, ocrPageResult.pageNumber) && Objects.equals(this.meanConfidenceLevel, ocrPageResult.meanConfidenceLevel) && Objects.equals(this.textResult, ocrPageResult.textResult);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.meanConfidenceLevel, this.textResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OcrPageResult {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    meanConfidenceLevel: ").append(this.toIndentedString(this.meanConfidenceLevel)).append("\n");
        sb.append("    textResult: ").append(this.toIndentedString(this.textResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

