/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DetectedObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of detecting objects in an image")
@JsonPropertyOrder(value={"Successful", "Objects", "ObjectCount"})
@JsonTypeName(value="ObjectDetectionResult")
public class ObjectDetectionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_OBJECTS = "Objects";
    private List<DetectedObject> objects = null;
    public static final String JSON_PROPERTY_OBJECT_COUNT = "ObjectCount";
    private Integer objectCount;

    public ObjectDetectionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Was the image processed successfully?")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ObjectDetectionResult objects(List<DetectedObject> objects) {
        this.objects = objects;
        return this;
    }

    public ObjectDetectionResult addObjectsItem(DetectedObject objectsItem) {
        if (this.objects == null) {
            this.objects = new ArrayList<DetectedObject>();
        }
        this.objects.add(objectsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects detected in the scene")
    @JsonProperty(value="Objects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DetectedObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<DetectedObject> objects) {
        this.objects = objects;
    }

    public ObjectDetectionResult objectCount(Integer objectCount) {
        this.objectCount = objectCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of objects detected in the scene")
    @JsonProperty(value="ObjectCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getObjectCount() {
        return this.objectCount;
    }

    public void setObjectCount(Integer objectCount) {
        this.objectCount = objectCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectDetectionResult objectDetectionResult = (ObjectDetectionResult)o;
        return Objects.equals(this.successful, objectDetectionResult.successful) && Objects.equals(this.objects, objectDetectionResult.objects) && Objects.equals(this.objectCount, objectDetectionResult.objectCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.objects, this.objectCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectDetectionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    objects: ").append(this.toIndentedString(this.objects)).append("\n");
        sb.append("    objectCount: ").append(this.toIndentedString(this.objectCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

