/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.NsfwScannedFrame;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The result of scanning a video file for NSFW content")
@JsonPropertyOrder(value={"Successful", "HighestClassificationResult", "HighestScore", "TotalRacyFrames", "TotalNsfwFrames", "TotalFrames", "NsfwScannedFrames"})
@JsonTypeName(value="NsfwResult")
public class NsfwResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_HIGHEST_CLASSIFICATION_RESULT = "HighestClassificationResult";
    private String highestClassificationResult;
    public static final String JSON_PROPERTY_HIGHEST_SCORE = "HighestScore";
    private Double highestScore;
    public static final String JSON_PROPERTY_TOTAL_RACY_FRAMES = "TotalRacyFrames";
    private Integer totalRacyFrames;
    public static final String JSON_PROPERTY_TOTAL_NSFW_FRAMES = "TotalNsfwFrames";
    private Integer totalNsfwFrames;
    public static final String JSON_PROPERTY_TOTAL_FRAMES = "TotalFrames";
    private Integer totalFrames;
    public static final String JSON_PROPERTY_NSFW_SCANNED_FRAMES = "NsfwScannedFrames";
    private List<NsfwScannedFrame> nsfwScannedFrames = null;

    public NsfwResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public NsfwResult highestClassificationResult(String highestClassificationResult) {
        this.highestClassificationResult = highestClassificationResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The highest NSFW classification of the video")
    @JsonProperty(value="HighestClassificationResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHighestClassificationResult() {
        return this.highestClassificationResult;
    }

    public void setHighestClassificationResult(String highestClassificationResult) {
        this.highestClassificationResult = highestClassificationResult;
    }

    public NsfwResult highestScore(Double highestScore) {
        this.highestScore = highestScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The highest NSFW score out of all frames scanned")
    @JsonProperty(value="HighestScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getHighestScore() {
        return this.highestScore;
    }

    public void setHighestScore(Double highestScore) {
        this.highestScore = highestScore;
    }

    public NsfwResult totalRacyFrames(Integer totalRacyFrames) {
        this.totalRacyFrames = totalRacyFrames;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of potentially \"racy\" frames.")
    @JsonProperty(value="TotalRacyFrames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalRacyFrames() {
        return this.totalRacyFrames;
    }

    public void setTotalRacyFrames(Integer totalRacyFrames) {
        this.totalRacyFrames = totalRacyFrames;
    }

    public NsfwResult totalNsfwFrames(Integer totalNsfwFrames) {
        this.totalNsfwFrames = totalNsfwFrames;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of frames with high probability of NSFW.")
    @JsonProperty(value="TotalNsfwFrames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalNsfwFrames() {
        return this.totalNsfwFrames;
    }

    public void setTotalNsfwFrames(Integer totalNsfwFrames) {
        this.totalNsfwFrames = totalNsfwFrames;
    }

    public NsfwResult totalFrames(Integer totalFrames) {
        this.totalFrames = totalFrames;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of frames scanned")
    @JsonProperty(value="TotalFrames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalFrames() {
        return this.totalFrames;
    }

    public void setTotalFrames(Integer totalFrames) {
        this.totalFrames = totalFrames;
    }

    public NsfwResult nsfwScannedFrames(List<NsfwScannedFrame> nsfwScannedFrames) {
        this.nsfwScannedFrames = nsfwScannedFrames;
        return this;
    }

    public NsfwResult addNsfwScannedFramesItem(NsfwScannedFrame nsfwScannedFramesItem) {
        if (this.nsfwScannedFrames == null) {
            this.nsfwScannedFrames = new ArrayList<NsfwScannedFrame>();
        }
        this.nsfwScannedFrames.add(nsfwScannedFramesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The NSFW scanning results for each frame")
    @JsonProperty(value="NsfwScannedFrames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NsfwScannedFrame> getNsfwScannedFrames() {
        return this.nsfwScannedFrames;
    }

    public void setNsfwScannedFrames(List<NsfwScannedFrame> nsfwScannedFrames) {
        this.nsfwScannedFrames = nsfwScannedFrames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NsfwResult nsfwResult = (NsfwResult)o;
        return Objects.equals(this.successful, nsfwResult.successful) && Objects.equals(this.highestClassificationResult, nsfwResult.highestClassificationResult) && Objects.equals(this.highestScore, nsfwResult.highestScore) && Objects.equals(this.totalRacyFrames, nsfwResult.totalRacyFrames) && Objects.equals(this.totalNsfwFrames, nsfwResult.totalNsfwFrames) && Objects.equals(this.totalFrames, nsfwResult.totalFrames) && Objects.equals(this.nsfwScannedFrames, nsfwResult.nsfwScannedFrames);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.highestClassificationResult, this.highestScore, this.totalRacyFrames, this.totalNsfwFrames, this.totalFrames, this.nsfwScannedFrames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NsfwResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    highestClassificationResult: ").append(this.toIndentedString(this.highestClassificationResult)).append("\n");
        sb.append("    highestScore: ").append(this.toIndentedString(this.highestScore)).append("\n");
        sb.append("    totalRacyFrames: ").append(this.toIndentedString(this.totalRacyFrames)).append("\n");
        sb.append("    totalNsfwFrames: ").append(this.toIndentedString(this.totalNsfwFrames)).append("\n");
        sb.append("    totalFrames: ").append(this.toIndentedString(this.totalFrames)).append("\n");
        sb.append("    nsfwScannedFrames: ").append(this.toIndentedString(this.nsfwScannedFrames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

