/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.PageConversionResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of converting a multi-page image into individual pages with a different format")
@JsonPropertyOrder(value={"Successful", "PageCount", "Pages"})
@JsonTypeName(value="MultipageImageFormatConversionResult")
public class MultipageImageFormatConversionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_PAGE_COUNT = "PageCount";
    private Integer pageCount;
    public static final String JSON_PROPERTY_PAGES = "Pages";
    private List<PageConversionResult> pages = null;

    public MultipageImageFormatConversionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public MultipageImageFormatConversionResult pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pages in the converted output")
    @JsonProperty(value="PageCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public MultipageImageFormatConversionResult pages(List<PageConversionResult> pages) {
        this.pages = pages;
        return this;
    }

    public MultipageImageFormatConversionResult addPagesItem(PageConversionResult pagesItem) {
        if (this.pages == null) {
            this.pages = new ArrayList<PageConversionResult>();
        }
        this.pages.add(pagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Converted page results")
    @JsonProperty(value="Pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PageConversionResult> getPages() {
        return this.pages;
    }

    public void setPages(List<PageConversionResult> pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipageImageFormatConversionResult multipageImageFormatConversionResult = (MultipageImageFormatConversionResult)o;
        return Objects.equals(this.successful, multipageImageFormatConversionResult.successful) && Objects.equals(this.pageCount, multipageImageFormatConversionResult.pageCount) && Objects.equals(this.pages, multipageImageFormatConversionResult.pages);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.pageCount, this.pages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultipageImageFormatConversionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

