/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input lead contact; fill in known fields to extend them with matched field values")
@JsonPropertyOrder(value={"ContactBusinessEmail", "ContactFirstName", "ContactLastName", "CompanyName", "CompanyDomainName", "CompanyHouseNumber", "CompanyStreet", "CompanyCity", "CompanyStateOrProvince", "CompanyPostalCode", "CompanyCountry", "CompanyCountryCode", "CompanyTelephone", "CompanyVATNumber"})
@JsonTypeName(value="LeadEnrichmentRequest")
public class LeadEnrichmentRequest {
    public static final String JSON_PROPERTY_CONTACT_BUSINESS_EMAIL = "ContactBusinessEmail";
    private String contactBusinessEmail;
    public static final String JSON_PROPERTY_CONTACT_FIRST_NAME = "ContactFirstName";
    private String contactFirstName;
    public static final String JSON_PROPERTY_CONTACT_LAST_NAME = "ContactLastName";
    private String contactLastName;
    public static final String JSON_PROPERTY_COMPANY_NAME = "CompanyName";
    private String companyName;
    public static final String JSON_PROPERTY_COMPANY_DOMAIN_NAME = "CompanyDomainName";
    private String companyDomainName;
    public static final String JSON_PROPERTY_COMPANY_HOUSE_NUMBER = "CompanyHouseNumber";
    private String companyHouseNumber;
    public static final String JSON_PROPERTY_COMPANY_STREET = "CompanyStreet";
    private String companyStreet;
    public static final String JSON_PROPERTY_COMPANY_CITY = "CompanyCity";
    private String companyCity;
    public static final String JSON_PROPERTY_COMPANY_STATE_OR_PROVINCE = "CompanyStateOrProvince";
    private String companyStateOrProvince;
    public static final String JSON_PROPERTY_COMPANY_POSTAL_CODE = "CompanyPostalCode";
    private String companyPostalCode;
    public static final String JSON_PROPERTY_COMPANY_COUNTRY = "CompanyCountry";
    private String companyCountry;
    public static final String JSON_PROPERTY_COMPANY_COUNTRY_CODE = "CompanyCountryCode";
    private String companyCountryCode;
    public static final String JSON_PROPERTY_COMPANY_TELEPHONE = "CompanyTelephone";
    private String companyTelephone;
    public static final String JSON_PROPERTY_COMPANY_V_A_T_NUMBER = "CompanyVATNumber";
    private String companyVATNumber;

    public LeadEnrichmentRequest contactBusinessEmail(String contactBusinessEmail) {
        this.contactBusinessEmail = contactBusinessEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's business email address for the lead")
    @JsonProperty(value="ContactBusinessEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactBusinessEmail() {
        return this.contactBusinessEmail;
    }

    public void setContactBusinessEmail(String contactBusinessEmail) {
        this.contactBusinessEmail = contactBusinessEmail;
    }

    public LeadEnrichmentRequest contactFirstName(String contactFirstName) {
        this.contactFirstName = contactFirstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's first name for the lead")
    @JsonProperty(value="ContactFirstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactFirstName() {
        return this.contactFirstName;
    }

    public void setContactFirstName(String contactFirstName) {
        this.contactFirstName = contactFirstName;
    }

    public LeadEnrichmentRequest contactLastName(String contactLastName) {
        this.contactLastName = contactLastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's last name for the lead")
    @JsonProperty(value="ContactLastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactLastName() {
        return this.contactLastName;
    }

    public void setContactLastName(String contactLastName) {
        this.contactLastName = contactLastName;
    }

    public LeadEnrichmentRequest companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the company for the lead")
    @JsonProperty(value="CompanyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public LeadEnrichmentRequest companyDomainName(String companyDomainName) {
        this.companyDomainName = companyDomainName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Domain name / website for the lead")
    @JsonProperty(value="CompanyDomainName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyDomainName() {
        return this.companyDomainName;
    }

    public void setCompanyDomainName(String companyDomainName) {
        this.companyDomainName = companyDomainName;
    }

    public LeadEnrichmentRequest companyHouseNumber(String companyHouseNumber) {
        this.companyHouseNumber = companyHouseNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="House number of the address of the company for the lead")
    @JsonProperty(value="CompanyHouseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyHouseNumber() {
        return this.companyHouseNumber;
    }

    public void setCompanyHouseNumber(String companyHouseNumber) {
        this.companyHouseNumber = companyHouseNumber;
    }

    public LeadEnrichmentRequest companyStreet(String companyStreet) {
        this.companyStreet = companyStreet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street name of the address of the company for the lead")
    @JsonProperty(value="CompanyStreet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyStreet() {
        return this.companyStreet;
    }

    public void setCompanyStreet(String companyStreet) {
        this.companyStreet = companyStreet;
    }

    public LeadEnrichmentRequest companyCity(String companyCity) {
        this.companyCity = companyCity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="City of the address of the company for the lead")
    @JsonProperty(value="CompanyCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyCity() {
        return this.companyCity;
    }

    public void setCompanyCity(String companyCity) {
        this.companyCity = companyCity;
    }

    public LeadEnrichmentRequest companyStateOrProvince(String companyStateOrProvince) {
        this.companyStateOrProvince = companyStateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State or Province of the address of the company for the lead")
    @JsonProperty(value="CompanyStateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyStateOrProvince() {
        return this.companyStateOrProvince;
    }

    public void setCompanyStateOrProvince(String companyStateOrProvince) {
        this.companyStateOrProvince = companyStateOrProvince;
    }

    public LeadEnrichmentRequest companyPostalCode(String companyPostalCode) {
        this.companyPostalCode = companyPostalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Postal Code of the address of the company for the lead")
    @JsonProperty(value="CompanyPostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyPostalCode() {
        return this.companyPostalCode;
    }

    public void setCompanyPostalCode(String companyPostalCode) {
        this.companyPostalCode = companyPostalCode;
    }

    public LeadEnrichmentRequest companyCountry(String companyCountry) {
        this.companyCountry = companyCountry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country of the address of the company for the lead")
    @JsonProperty(value="CompanyCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyCountry() {
        return this.companyCountry;
    }

    public void setCompanyCountry(String companyCountry) {
        this.companyCountry = companyCountry;
    }

    public LeadEnrichmentRequest companyCountryCode(String companyCountryCode) {
        this.companyCountryCode = companyCountryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country Code (2-letter ISO 3166-1) of the address of the company for the lead")
    @JsonProperty(value="CompanyCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyCountryCode() {
        return this.companyCountryCode;
    }

    public void setCompanyCountryCode(String companyCountryCode) {
        this.companyCountryCode = companyCountryCode;
    }

    public LeadEnrichmentRequest companyTelephone(String companyTelephone) {
        this.companyTelephone = companyTelephone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Telephone of the company office for the lead")
    @JsonProperty(value="CompanyTelephone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyTelephone() {
        return this.companyTelephone;
    }

    public void setCompanyTelephone(String companyTelephone) {
        this.companyTelephone = companyTelephone;
    }

    public LeadEnrichmentRequest companyVATNumber(String companyVATNumber) {
        this.companyVATNumber = companyVATNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VAT number of the company for the lead")
    @JsonProperty(value="CompanyVATNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyVATNumber() {
        return this.companyVATNumber;
    }

    public void setCompanyVATNumber(String companyVATNumber) {
        this.companyVATNumber = companyVATNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeadEnrichmentRequest leadEnrichmentRequest = (LeadEnrichmentRequest)o;
        return Objects.equals(this.contactBusinessEmail, leadEnrichmentRequest.contactBusinessEmail) && Objects.equals(this.contactFirstName, leadEnrichmentRequest.contactFirstName) && Objects.equals(this.contactLastName, leadEnrichmentRequest.contactLastName) && Objects.equals(this.companyName, leadEnrichmentRequest.companyName) && Objects.equals(this.companyDomainName, leadEnrichmentRequest.companyDomainName) && Objects.equals(this.companyHouseNumber, leadEnrichmentRequest.companyHouseNumber) && Objects.equals(this.companyStreet, leadEnrichmentRequest.companyStreet) && Objects.equals(this.companyCity, leadEnrichmentRequest.companyCity) && Objects.equals(this.companyStateOrProvince, leadEnrichmentRequest.companyStateOrProvince) && Objects.equals(this.companyPostalCode, leadEnrichmentRequest.companyPostalCode) && Objects.equals(this.companyCountry, leadEnrichmentRequest.companyCountry) && Objects.equals(this.companyCountryCode, leadEnrichmentRequest.companyCountryCode) && Objects.equals(this.companyTelephone, leadEnrichmentRequest.companyTelephone) && Objects.equals(this.companyVATNumber, leadEnrichmentRequest.companyVATNumber);
    }

    public int hashCode() {
        return Objects.hash(this.contactBusinessEmail, this.contactFirstName, this.contactLastName, this.companyName, this.companyDomainName, this.companyHouseNumber, this.companyStreet, this.companyCity, this.companyStateOrProvince, this.companyPostalCode, this.companyCountry, this.companyCountryCode, this.companyTelephone, this.companyVATNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LeadEnrichmentRequest {\n");
        sb.append("    contactBusinessEmail: ").append(this.toIndentedString(this.contactBusinessEmail)).append("\n");
        sb.append("    contactFirstName: ").append(this.toIndentedString(this.contactFirstName)).append("\n");
        sb.append("    contactLastName: ").append(this.toIndentedString(this.contactLastName)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    companyDomainName: ").append(this.toIndentedString(this.companyDomainName)).append("\n");
        sb.append("    companyHouseNumber: ").append(this.toIndentedString(this.companyHouseNumber)).append("\n");
        sb.append("    companyStreet: ").append(this.toIndentedString(this.companyStreet)).append("\n");
        sb.append("    companyCity: ").append(this.toIndentedString(this.companyCity)).append("\n");
        sb.append("    companyStateOrProvince: ").append(this.toIndentedString(this.companyStateOrProvince)).append("\n");
        sb.append("    companyPostalCode: ").append(this.toIndentedString(this.companyPostalCode)).append("\n");
        sb.append("    companyCountry: ").append(this.toIndentedString(this.companyCountry)).append("\n");
        sb.append("    companyCountryCode: ").append(this.toIndentedString(this.companyCountryCode)).append("\n");
        sb.append("    companyTelephone: ").append(this.toIndentedString(this.companyTelephone)).append("\n");
        sb.append("    companyVATNumber: ").append(this.toIndentedString(this.companyVATNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

