/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a language detection operation")
@JsonPropertyOrder(value={"Successful", "DetectedLanguage_ThreeLetterCode", "DetectedLanguage_FullName"})
@JsonTypeName(value="LanguageDetectionResponse")
public class LanguageDetectionResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_DETECTED_LANGUAGE_THREE_LETTER_CODE = "DetectedLanguage_ThreeLetterCode";
    private String detectedLanguageThreeLetterCode;
    public static final String JSON_PROPERTY_DETECTED_LANGUAGE_FULL_NAME = "DetectedLanguage_FullName";
    private String detectedLanguageFullName;

    public LanguageDetectionResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the language detection operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public LanguageDetectionResponse detectedLanguageThreeLetterCode(String detectedLanguageThreeLetterCode) {
        this.detectedLanguageThreeLetterCode = detectedLanguageThreeLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO 639 three letter language code")
    @JsonProperty(value="DetectedLanguage_ThreeLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetectedLanguageThreeLetterCode() {
        return this.detectedLanguageThreeLetterCode;
    }

    public void setDetectedLanguageThreeLetterCode(String detectedLanguageThreeLetterCode) {
        this.detectedLanguageThreeLetterCode = detectedLanguageThreeLetterCode;
    }

    public LanguageDetectionResponse detectedLanguageFullName(String detectedLanguageFullName) {
        this.detectedLanguageFullName = detectedLanguageFullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full name (in English) of the detected language")
    @JsonProperty(value="DetectedLanguage_FullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetectedLanguageFullName() {
        return this.detectedLanguageFullName;
    }

    public void setDetectedLanguageFullName(String detectedLanguageFullName) {
        this.detectedLanguageFullName = detectedLanguageFullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageDetectionResponse languageDetectionResponse = (LanguageDetectionResponse)o;
        return Objects.equals(this.successful, languageDetectionResponse.successful) && Objects.equals(this.detectedLanguageThreeLetterCode, languageDetectionResponse.detectedLanguageThreeLetterCode) && Objects.equals(this.detectedLanguageFullName, languageDetectionResponse.detectedLanguageFullName);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.detectedLanguageThreeLetterCode, this.detectedLanguageFullName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LanguageDetectionResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    detectedLanguageThreeLetterCode: ").append(this.toIndentedString(this.detectedLanguageThreeLetterCode)).append("\n");
        sb.append("    detectedLanguageFullName: ").append(this.toIndentedString(this.detectedLanguageFullName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

