/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxTable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Insert Tables request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "TableToInsert", "InsertPlacement", "InsertPath"})
@JsonTypeName(value="InsertDocxTablesRequest")
public class InsertDocxTablesRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_TABLE_TO_INSERT = "TableToInsert";
    private DocxTable tableToInsert;
    public static final String JSON_PROPERTY_INSERT_PLACEMENT = "InsertPlacement";
    private String insertPlacement;
    public static final String JSON_PROPERTY_INSERT_PATH = "InsertPath";
    private String insertPath;

    public InsertDocxTablesRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public InsertDocxTablesRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public InsertDocxTablesRequest tableToInsert(DocxTable tableToInsert) {
        this.tableToInsert = tableToInsert;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="TableToInsert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocxTable getTableToInsert() {
        return this.tableToInsert;
    }

    public void setTableToInsert(DocxTable tableToInsert) {
        this.tableToInsert = tableToInsert;
    }

    public InsertDocxTablesRequest insertPlacement(String insertPlacement) {
        this.insertPlacement = insertPlacement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; default is DocumentEnd.  Placement Type of the insert; possible values are: DocumentStart (very beginning of the document), DocumentEnd (very end of the document), BeforeExistingObject (right before an existing object - fill in the InsertPath field using the Path value from an existing object), AfterExistingObject (right after an existing object - fill in the InsertPath field using the Path value from an existing object)")
    @JsonProperty(value="InsertPlacement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInsertPlacement() {
        return this.insertPlacement;
    }

    public void setInsertPlacement(String insertPlacement) {
        this.insertPlacement = insertPlacement;
    }

    public InsertDocxTablesRequest insertPath(String insertPath) {
        this.insertPath = insertPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; location within the document to insert the object; fill in the InsertPath field using the Path value from an existing object.  Used with InsertPlacement of BeforeExistingObject or AfterExistingObject")
    @JsonProperty(value="InsertPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInsertPath() {
        return this.insertPath;
    }

    public void setInsertPath(String insertPath) {
        this.insertPath = insertPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertDocxTablesRequest insertDocxTablesRequest = (InsertDocxTablesRequest)o;
        return Arrays.equals(this.inputFileBytes, insertDocxTablesRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, insertDocxTablesRequest.inputFileUrl) && Objects.equals(this.tableToInsert, insertDocxTablesRequest.tableToInsert) && Objects.equals(this.insertPlacement, insertDocxTablesRequest.insertPlacement) && Objects.equals(this.insertPath, insertDocxTablesRequest.insertPath);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.tableToInsert, this.insertPlacement, this.insertPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsertDocxTablesRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    tableToInsert: ").append(this.toIndentedString(this.tableToInsert)).append("\n");
        sb.append("    insertPlacement: ").append(this.toIndentedString(this.insertPlacement)).append("\n");
        sb.append("    insertPath: ").append(this.toIndentedString(this.insertPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

