/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.OcrWordElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of an image to words-with-location OCR operation")
@JsonPropertyOrder(value={"Successful", "Words"})
@JsonTypeName(value="ImageToWordsWithLocationResult")
public class ImageToWordsWithLocationResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_WORDS = "Words";
    private List<OcrWordElement> words = null;

    public ImageToWordsWithLocationResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ImageToWordsWithLocationResult words(List<OcrWordElement> words) {
        this.words = words;
        return this;
    }

    public ImageToWordsWithLocationResult addWordsItem(OcrWordElement wordsItem) {
        if (this.words == null) {
            this.words = new ArrayList<OcrWordElement>();
        }
        this.words.add(wordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Word elements in the image")
    @JsonProperty(value="Words")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OcrWordElement> getWords() {
        return this.words;
    }

    public void setWords(List<OcrWordElement> words) {
        this.words = words;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageToWordsWithLocationResult imageToWordsWithLocationResult = (ImageToWordsWithLocationResult)o;
        return Objects.equals(this.successful, imageToWordsWithLocationResult.successful) && Objects.equals(this.words, imageToWordsWithLocationResult.words);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.words);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageToWordsWithLocationResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    words: ").append(this.toIndentedString(this.words)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

