/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response from an OCR to text operation.  Includes the confience rating and converted text result.")
@JsonPropertyOrder(value={"MeanConfidenceLevel", "TextResult"})
@JsonTypeName(value="ImageToTextResponse")
public class ImageToTextResponse {
    public static final String JSON_PROPERTY_MEAN_CONFIDENCE_LEVEL = "MeanConfidenceLevel";
    private Float meanConfidenceLevel;
    public static final String JSON_PROPERTY_TEXT_RESULT = "TextResult";
    private String textResult;

    public ImageToTextResponse meanConfidenceLevel(Float meanConfidenceLevel) {
        this.meanConfidenceLevel = meanConfidenceLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence level rating of the OCR operation; ratings above 80% are strong.")
    @JsonProperty(value="MeanConfidenceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getMeanConfidenceLevel() {
        return this.meanConfidenceLevel;
    }

    public void setMeanConfidenceLevel(Float meanConfidenceLevel) {
        this.meanConfidenceLevel = meanConfidenceLevel;
    }

    public ImageToTextResponse textResult(String textResult) {
        this.textResult = textResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Converted text string from the image input.")
    @JsonProperty(value="TextResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextResult() {
        return this.textResult;
    }

    public void setTextResult(String textResult) {
        this.textResult = textResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageToTextResponse imageToTextResponse = (ImageToTextResponse)o;
        return Objects.equals(this.meanConfidenceLevel, imageToTextResponse.meanConfidenceLevel) && Objects.equals(this.textResult, imageToTextResponse.textResult);
    }

    public int hashCode() {
        return Objects.hash(this.meanConfidenceLevel, this.textResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageToTextResponse {\n");
        sb.append("    meanConfidenceLevel: ").append(this.toIndentedString(this.meanConfidenceLevel)).append("\n");
        sb.append("    textResult: ").append(this.toIndentedString(this.textResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

