/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.HtmlTemplateOperation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HTML template application request")
@JsonPropertyOrder(value={"HtmlTemplate", "HtmlTemplateUrl", "Operations"})
@JsonTypeName(value="HtmlTemplateApplicationRequest")
public class HtmlTemplateApplicationRequest {
    public static final String JSON_PROPERTY_HTML_TEMPLATE = "HtmlTemplate";
    private String htmlTemplate;
    public static final String JSON_PROPERTY_HTML_TEMPLATE_URL = "HtmlTemplateUrl";
    private String htmlTemplateUrl;
    public static final String JSON_PROPERTY_OPERATIONS = "Operations";
    private List<HtmlTemplateOperation> operations = null;

    public HtmlTemplateApplicationRequest htmlTemplate(String htmlTemplate) {
        this.htmlTemplate = htmlTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTML template input as a string")
    @JsonProperty(value="HtmlTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHtmlTemplate() {
        return this.htmlTemplate;
    }

    public void setHtmlTemplate(String htmlTemplate) {
        this.htmlTemplate = htmlTemplate;
    }

    public HtmlTemplateApplicationRequest htmlTemplateUrl(String htmlTemplateUrl) {
        this.htmlTemplateUrl = htmlTemplateUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to HTML template input")
    @JsonProperty(value="HtmlTemplateUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHtmlTemplateUrl() {
        return this.htmlTemplateUrl;
    }

    public void setHtmlTemplateUrl(String htmlTemplateUrl) {
        this.htmlTemplateUrl = htmlTemplateUrl;
    }

    public HtmlTemplateApplicationRequest operations(List<HtmlTemplateOperation> operations) {
        this.operations = operations;
        return this;
    }

    public HtmlTemplateApplicationRequest addOperationsItem(HtmlTemplateOperation operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<HtmlTemplateOperation>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operations to apply to this template")
    @JsonProperty(value="Operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HtmlTemplateOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<HtmlTemplateOperation> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlTemplateApplicationRequest htmlTemplateApplicationRequest = (HtmlTemplateApplicationRequest)o;
        return Objects.equals(this.htmlTemplate, htmlTemplateApplicationRequest.htmlTemplate) && Objects.equals(this.htmlTemplateUrl, htmlTemplateApplicationRequest.htmlTemplateUrl) && Objects.equals(this.operations, htmlTemplateApplicationRequest.operations);
    }

    public int hashCode() {
        return Objects.hash(this.htmlTemplate, this.htmlTemplateUrl, this.operations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HtmlTemplateApplicationRequest {\n");
        sb.append("    htmlTemplate: ").append(this.toIndentedString(this.htmlTemplate)).append("\n");
        sb.append("    htmlTemplateUrl: ").append(this.toIndentedString(this.htmlTemplateUrl)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

