/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a hate speech analysis operation")
@JsonPropertyOrder(value={"Successful", "HateSpeechScoreResult", "SentenceCount"})
@JsonTypeName(value="HateSpeechAnalysisResponse")
public class HateSpeechAnalysisResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_HATE_SPEECH_SCORE_RESULT = "HateSpeechScoreResult";
    private Double hateSpeechScoreResult;
    public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
    private Integer sentenceCount;

    public HateSpeechAnalysisResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the profanity detection operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public HateSpeechAnalysisResponse hateSpeechScoreResult(Double hateSpeechScoreResult) {
        this.hateSpeechScoreResult = hateSpeechScoreResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hate speech classification score between 0.0 and 1.0 where scores closer to zero have a low probability of being hate speech language, while scores close to 1.0 have a high probability of being hate speech language.  Values above 0.8 have a very high probability of being hate speech.")
    @JsonProperty(value="HateSpeechScoreResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getHateSpeechScoreResult() {
        return this.hateSpeechScoreResult;
    }

    public void setHateSpeechScoreResult(Double hateSpeechScoreResult) {
        this.hateSpeechScoreResult = hateSpeechScoreResult;
    }

    public HateSpeechAnalysisResponse sentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of sentences in input text")
    @JsonProperty(value="SentenceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HateSpeechAnalysisResponse hateSpeechAnalysisResponse = (HateSpeechAnalysisResponse)o;
        return Objects.equals(this.successful, hateSpeechAnalysisResponse.successful) && Objects.equals(this.hateSpeechScoreResult, hateSpeechAnalysisResponse.hateSpeechScoreResult) && Objects.equals(this.sentenceCount, hateSpeechAnalysisResponse.sentenceCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.hateSpeechScoreResult, this.sentenceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HateSpeechAnalysisResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    hateSpeechScoreResult: ").append(this.toIndentedString(this.hateSpeechScoreResult)).append("\n");
        sb.append("    sentenceCount: ").append(this.toIndentedString(this.sentenceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

