/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.PdfAnnotation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of retrieving annotations from a PDF document")
@JsonPropertyOrder(value={"Successful", "Annotations"})
@JsonTypeName(value="GetPdfAnnotationsResult")
public class GetPdfAnnotationsResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_ANNOTATIONS = "Annotations";
    private List<PdfAnnotation> annotations = null;

    public GetPdfAnnotationsResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public GetPdfAnnotationsResult annotations(List<PdfAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public GetPdfAnnotationsResult addAnnotationsItem(PdfAnnotation annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<PdfAnnotation>();
        }
        this.annotations.add(annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Annotations in the PDF file, ordered by placement from start to finish in the document")
    @JsonProperty(value="Annotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PdfAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<PdfAnnotation> annotations) {
        this.annotations = annotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPdfAnnotationsResult getPdfAnnotationsResult = (GetPdfAnnotationsResult)o;
        return Objects.equals(this.successful, getPdfAnnotationsResult.successful) && Objects.equals(this.annotations, getPdfAnnotationsResult.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.annotations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetPdfAnnotationsResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

