/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ExifValue;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of running a get-info operation on an image")
@JsonPropertyOrder(value={"Successful", "ColorSpace", "ColorType", "Width", "Height", "CompressionLevel", "ImageHashSignature", "HasTransparency", "MimeType", "ImageFormat", "DPIUnit", "DPI", "ColorCount", "BitDepth", "Comment", "ExifProfileName", "ExifValues"})
@JsonTypeName(value="GetImageInfoResult")
public class GetImageInfoResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_COLOR_SPACE = "ColorSpace";
    private String colorSpace;
    public static final String JSON_PROPERTY_COLOR_TYPE = "ColorType";
    private String colorType;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_COMPRESSION_LEVEL = "CompressionLevel";
    private Integer compressionLevel;
    public static final String JSON_PROPERTY_IMAGE_HASH_SIGNATURE = "ImageHashSignature";
    private String imageHashSignature;
    public static final String JSON_PROPERTY_HAS_TRANSPARENCY = "HasTransparency";
    private Boolean hasTransparency;
    public static final String JSON_PROPERTY_MIME_TYPE = "MimeType";
    private String mimeType;
    public static final String JSON_PROPERTY_IMAGE_FORMAT = "ImageFormat";
    private String imageFormat;
    public static final String JSON_PROPERTY_DP_I_UNIT = "DPIUnit";
    private String dpIUnit;
    public static final String JSON_PROPERTY_D_P_I = "DPI";
    private Double DPI;
    public static final String JSON_PROPERTY_COLOR_COUNT = "ColorCount";
    private Integer colorCount;
    public static final String JSON_PROPERTY_BIT_DEPTH = "BitDepth";
    private Integer bitDepth;
    public static final String JSON_PROPERTY_COMMENT = "Comment";
    private String comment;
    public static final String JSON_PROPERTY_EXIF_PROFILE_NAME = "ExifProfileName";
    private String exifProfileName;
    public static final String JSON_PROPERTY_EXIF_VALUES = "ExifValues";
    private List<ExifValue> exifValues = null;

    public GetImageInfoResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public GetImageInfoResult colorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color space of the image")
    @JsonProperty(value="ColorSpace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
    }

    public GetImageInfoResult colorType(String colorType) {
        this.colorType = colorType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color type of the image")
    @JsonProperty(value="ColorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColorType() {
        return this.colorType;
    }

    public void setColorType(String colorType) {
        this.colorType = colorType;
    }

    public GetImageInfoResult width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width in pixels of the image")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public GetImageInfoResult height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height in pixels of the image")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public GetImageInfoResult compressionLevel(Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Compression level value from 0 (lowest quality) to 100 (highest quality)")
    @JsonProperty(value="CompressionLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public GetImageInfoResult imageHashSignature(String imageHashSignature) {
        this.imageHashSignature = imageHashSignature;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SHA256 hash signature of the image")
    @JsonProperty(value="ImageHashSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageHashSignature() {
        return this.imageHashSignature;
    }

    public void setImageHashSignature(String imageHashSignature) {
        this.imageHashSignature = imageHashSignature;
    }

    public GetImageInfoResult hasTransparency(Boolean hasTransparency) {
        this.hasTransparency = hasTransparency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the image contains transparency, otherwise false")
    @JsonProperty(value="HasTransparency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasTransparency() {
        return this.hasTransparency;
    }

    public void setHasTransparency(Boolean hasTransparency) {
        this.hasTransparency = hasTransparency;
    }

    public GetImageInfoResult mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MIME type of the image format")
    @JsonProperty(value="MimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public GetImageInfoResult imageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image format")
    @JsonProperty(value="ImageFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public GetImageInfoResult dpIUnit(String dpIUnit) {
        this.dpIUnit = dpIUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Units of the DPI measurement; can be either in Inches or Centimeters")
    @JsonProperty(value="DPIUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDpIUnit() {
        return this.dpIUnit;
    }

    public void setDpIUnit(String dpIUnit) {
        this.dpIUnit = dpIUnit;
    }

    public GetImageInfoResult DPI(Double DPI) {
        this.DPI = DPI;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DPI (pixels per unit, e.g. pixels per inch) of the image")
    @JsonProperty(value="DPI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDPI() {
        return this.DPI;
    }

    public void setDPI(Double DPI) {
        this.DPI = DPI;
    }

    public GetImageInfoResult colorCount(Integer colorCount) {
        this.colorCount = colorCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique colors in the image")
    @JsonProperty(value="ColorCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getColorCount() {
        return this.colorCount;
    }

    public void setColorCount(Integer colorCount) {
        this.colorCount = colorCount;
    }

    public GetImageInfoResult bitDepth(Integer bitDepth) {
        this.bitDepth = bitDepth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Bit depth of the image")
    @JsonProperty(value="BitDepth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(Integer bitDepth) {
        this.bitDepth = bitDepth;
    }

    public GetImageInfoResult comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Comment string in the image")
    @JsonProperty(value="Comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public GetImageInfoResult exifProfileName(String exifProfileName) {
        this.exifProfileName = exifProfileName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the EXIF profile used")
    @JsonProperty(value="ExifProfileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExifProfileName() {
        return this.exifProfileName;
    }

    public void setExifProfileName(String exifProfileName) {
        this.exifProfileName = exifProfileName;
    }

    public GetImageInfoResult exifValues(List<ExifValue> exifValues) {
        this.exifValues = exifValues;
        return this;
    }

    public GetImageInfoResult addExifValuesItem(ExifValue exifValuesItem) {
        if (this.exifValues == null) {
            this.exifValues = new ArrayList<ExifValue>();
        }
        this.exifValues.add(exifValuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EXIF tags and values embedded in the image")
    @JsonProperty(value="ExifValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExifValue> getExifValues() {
        return this.exifValues;
    }

    public void setExifValues(List<ExifValue> exifValues) {
        this.exifValues = exifValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetImageInfoResult getImageInfoResult = (GetImageInfoResult)o;
        return Objects.equals(this.successful, getImageInfoResult.successful) && Objects.equals(this.colorSpace, getImageInfoResult.colorSpace) && Objects.equals(this.colorType, getImageInfoResult.colorType) && Objects.equals(this.width, getImageInfoResult.width) && Objects.equals(this.height, getImageInfoResult.height) && Objects.equals(this.compressionLevel, getImageInfoResult.compressionLevel) && Objects.equals(this.imageHashSignature, getImageInfoResult.imageHashSignature) && Objects.equals(this.hasTransparency, getImageInfoResult.hasTransparency) && Objects.equals(this.mimeType, getImageInfoResult.mimeType) && Objects.equals(this.imageFormat, getImageInfoResult.imageFormat) && Objects.equals(this.dpIUnit, getImageInfoResult.dpIUnit) && Objects.equals(this.DPI, getImageInfoResult.DPI) && Objects.equals(this.colorCount, getImageInfoResult.colorCount) && Objects.equals(this.bitDepth, getImageInfoResult.bitDepth) && Objects.equals(this.comment, getImageInfoResult.comment) && Objects.equals(this.exifProfileName, getImageInfoResult.exifProfileName) && Objects.equals(this.exifValues, getImageInfoResult.exifValues);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.colorSpace, this.colorType, this.width, this.height, this.compressionLevel, this.imageHashSignature, this.hasTransparency, this.mimeType, this.imageFormat, this.dpIUnit, this.DPI, this.colorCount, this.bitDepth, this.comment, this.exifProfileName, this.exifValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetImageInfoResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    colorSpace: ").append(this.toIndentedString(this.colorSpace)).append("\n");
        sb.append("    colorType: ").append(this.toIndentedString(this.colorType)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    compressionLevel: ").append(this.toIndentedString(this.compressionLevel)).append("\n");
        sb.append("    imageHashSignature: ").append(this.toIndentedString(this.imageHashSignature)).append("\n");
        sb.append("    hasTransparency: ").append(this.toIndentedString(this.hasTransparency)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    imageFormat: ").append(this.toIndentedString(this.imageFormat)).append("\n");
        sb.append("    dpIUnit: ").append(this.toIndentedString(this.dpIUnit)).append("\n");
        sb.append("    DPI: ").append(this.toIndentedString(this.DPI)).append("\n");
        sb.append("    colorCount: ").append(this.toIndentedString(this.colorCount)).append("\n");
        sb.append("    bitDepth: ").append(this.toIndentedString(this.bitDepth)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    exifProfileName: ").append(this.toIndentedString(this.exifProfileName)).append("\n");
        sb.append("    exifValues: ").append(this.toIndentedString(this.exifValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

