/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Get Word DOCX Document Pages request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "MaximumPages"})
@JsonTypeName(value="GetDocxPagesRequest")
public class GetDocxPagesRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_MAXIMUM_PAGES = "MaximumPages";
    private Integer maximumPages;

    public GetDocxPagesRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public GetDocxPagesRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public GetDocxPagesRequest maximumPages(Integer maximumPages) {
        this.maximumPages = maximumPages;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Maximum number of pages to return; set to 0 or do not supply to return all pages")
    @JsonProperty(value="MaximumPages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaximumPages() {
        return this.maximumPages;
    }

    public void setMaximumPages(Integer maximumPages) {
        this.maximumPages = maximumPages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDocxPagesRequest getDocxPagesRequest = (GetDocxPagesRequest)o;
        return Arrays.equals(this.inputFileBytes, getDocxPagesRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, getDocxPagesRequest.inputFileUrl) && Objects.equals(this.maximumPages, getDocxPagesRequest.maximumPages);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.maximumPages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetDocxPagesRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    maximumPages: ").append(this.toIndentedString(this.maximumPages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

