/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Geolocation street address result")
@JsonPropertyOrder(value={"CountryCode", "CountryName", "StreetAddress", "City", "RegionName", "ZipCode"})
@JsonTypeName(value="GeolocateStreetAddressResponse")
public class GeolocateStreetAddressResponse {
    public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_COUNTRY_NAME = "CountryName";
    private String countryName;
    public static final String JSON_PROPERTY_STREET_ADDRESS = "StreetAddress";
    private String streetAddress;
    public static final String JSON_PROPERTY_CITY = "City";
    private String city;
    public static final String JSON_PROPERTY_REGION_NAME = "RegionName";
    private String regionName;
    public static final String JSON_PROPERTY_ZIP_CODE = "ZipCode";
    private String zipCode;

    public GeolocateStreetAddressResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two-letter country code of IP address")
    @JsonProperty(value="CountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public GeolocateStreetAddressResponse countryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country name of IP address")
    @JsonProperty(value="CountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public GeolocateStreetAddressResponse streetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street address of IP address")
    @JsonProperty(value="StreetAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public GeolocateStreetAddressResponse city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="City of IP address")
    @JsonProperty(value="City")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public GeolocateStreetAddressResponse regionName(String regionName) {
        this.regionName = regionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State/region of IP address")
    @JsonProperty(value="RegionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public GeolocateStreetAddressResponse zipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Zip or postal code of IP address")
    @JsonProperty(value="ZipCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeolocateStreetAddressResponse geolocateStreetAddressResponse = (GeolocateStreetAddressResponse)o;
        return Objects.equals(this.countryCode, geolocateStreetAddressResponse.countryCode) && Objects.equals(this.countryName, geolocateStreetAddressResponse.countryName) && Objects.equals(this.streetAddress, geolocateStreetAddressResponse.streetAddress) && Objects.equals(this.city, geolocateStreetAddressResponse.city) && Objects.equals(this.regionName, geolocateStreetAddressResponse.regionName) && Objects.equals(this.zipCode, geolocateStreetAddressResponse.zipCode);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.countryName, this.streetAddress, this.city, this.regionName, this.zipCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeolocateStreetAddressResponse {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    countryName: ").append(this.toIndentedString(this.countryName)).append("\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    regionName: ").append(this.toIndentedString(this.regionName)).append("\n");
        sb.append("    zipCode: ").append(this.toIndentedString(this.zipCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

