/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Definition of a form field for OCR data extraction from images")
@JsonPropertyOrder(value={"FieldID", "LeftAnchor", "TopAnchor", "BottomAnchor", "AlternateAnchor", "AnchorMode", "DataType", "TargetDigitCount", "MinimumCharacterCount", "AllowNumericDigits", "VerticalAlignmentType", "HorizontalAlignmentType", "TargetFieldWidth_Relative", "TargetFieldHeight_Relative", "TargetFieldHorizontalAdjustment", "TargetFieldVerticalAdjustment", "Ignore", "Options"})
@JsonTypeName(value="FormFieldDefinition")
public class FormFieldDefinition {
    public static final String JSON_PROPERTY_FIELD_I_D = "FieldID";
    private String fieldID;
    public static final String JSON_PROPERTY_LEFT_ANCHOR = "LeftAnchor";
    private String leftAnchor;
    public static final String JSON_PROPERTY_TOP_ANCHOR = "TopAnchor";
    private String topAnchor;
    public static final String JSON_PROPERTY_BOTTOM_ANCHOR = "BottomAnchor";
    private String bottomAnchor;
    public static final String JSON_PROPERTY_ALTERNATE_ANCHOR = "AlternateAnchor";
    private String alternateAnchor;
    public static final String JSON_PROPERTY_ANCHOR_MODE = "AnchorMode";
    private String anchorMode;
    public static final String JSON_PROPERTY_DATA_TYPE = "DataType";
    private String dataType;
    public static final String JSON_PROPERTY_TARGET_DIGIT_COUNT = "TargetDigitCount";
    private Integer targetDigitCount;
    public static final String JSON_PROPERTY_MINIMUM_CHARACTER_COUNT = "MinimumCharacterCount";
    private Integer minimumCharacterCount;
    public static final String JSON_PROPERTY_ALLOW_NUMERIC_DIGITS = "AllowNumericDigits";
    private Boolean allowNumericDigits;
    public static final String JSON_PROPERTY_VERTICAL_ALIGNMENT_TYPE = "VerticalAlignmentType";
    private String verticalAlignmentType;
    public static final String JSON_PROPERTY_HORIZONTAL_ALIGNMENT_TYPE = "HorizontalAlignmentType";
    private String horizontalAlignmentType;
    public static final String JSON_PROPERTY_TARGET_FIELD_WIDTH_RELATIVE = "TargetFieldWidth_Relative";
    private Double targetFieldWidthRelative;
    public static final String JSON_PROPERTY_TARGET_FIELD_HEIGHT_RELATIVE = "TargetFieldHeight_Relative";
    private Double targetFieldHeightRelative;
    public static final String JSON_PROPERTY_TARGET_FIELD_HORIZONTAL_ADJUSTMENT = "TargetFieldHorizontalAdjustment";
    private Double targetFieldHorizontalAdjustment;
    public static final String JSON_PROPERTY_TARGET_FIELD_VERTICAL_ADJUSTMENT = "TargetFieldVerticalAdjustment";
    private Double targetFieldVerticalAdjustment;
    public static final String JSON_PROPERTY_IGNORE = "Ignore";
    private List<String> ignore = null;
    public static final String JSON_PROPERTY_OPTIONS = "Options";
    private String options;

    public FormFieldDefinition fieldID(String fieldID) {
        this.fieldID = fieldID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the field; use this to identify which field is being referenced.  Set to SkipField if you do not wish to return the value of this field in the result.")
    @JsonProperty(value="FieldID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(String fieldID) {
        this.fieldID = fieldID;
    }

    public FormFieldDefinition leftAnchor(String leftAnchor) {
        this.leftAnchor = leftAnchor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the left-hand anchor of the field")
    @JsonProperty(value="LeftAnchor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLeftAnchor() {
        return this.leftAnchor;
    }

    public void setLeftAnchor(String leftAnchor) {
        this.leftAnchor = leftAnchor;
    }

    public FormFieldDefinition topAnchor(String topAnchor) {
        this.topAnchor = topAnchor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the top anchor of the field")
    @JsonProperty(value="TopAnchor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTopAnchor() {
        return this.topAnchor;
    }

    public void setTopAnchor(String topAnchor) {
        this.topAnchor = topAnchor;
    }

    public FormFieldDefinition bottomAnchor(String bottomAnchor) {
        this.bottomAnchor = bottomAnchor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the bottom anchor of the field")
    @JsonProperty(value="BottomAnchor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBottomAnchor() {
        return this.bottomAnchor;
    }

    public void setBottomAnchor(String bottomAnchor) {
        this.bottomAnchor = bottomAnchor;
    }

    public FormFieldDefinition alternateAnchor(String alternateAnchor) {
        this.alternateAnchor = alternateAnchor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - alterate match text for the specified anchor")
    @JsonProperty(value="AlternateAnchor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlternateAnchor() {
        return this.alternateAnchor;
    }

    public void setAlternateAnchor(String alternateAnchor) {
        this.alternateAnchor = alternateAnchor;
    }

    public FormFieldDefinition anchorMode(String anchorMode) {
        this.anchorMode = anchorMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the matching mode for the anchor.  Possible values are Complete (requires the entire anchor to match) and Partial (allows only part of the anchor to match) and Horizontal (anchor must be laid out horizontally).  Default is Partial.")
    @JsonProperty(value="AnchorMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnchorMode() {
        return this.anchorMode;
    }

    public void setAnchorMode(String anchorMode) {
        this.anchorMode = anchorMode;
    }

    public FormFieldDefinition dataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The data type of the field; possible values are INTEGER (Integer value), STRING (Arbitrary string value, spaces are permitted), DATE (Date in a structured format), DECIMAL (Decimal number), ALPHANUMERIC (Continuous alphanumeric string with no spaces), STRINGNOWHITESPACE (A string that contains no whitespace characters), SERIALNUMBER (A serial-number style string that contains letters and numbers, and certain symbols; must contain at least one number), ALPHAONLY (Alphabet characters only, no numbers or symbols or whitespace)")
    @JsonProperty(value="DataType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public FormFieldDefinition targetDigitCount(Integer targetDigitCount) {
        this.targetDigitCount = targetDigitCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the target number of digits in the field; useful for fixed-length fields")
    @JsonProperty(value="TargetDigitCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTargetDigitCount() {
        return this.targetDigitCount;
    }

    public void setTargetDigitCount(Integer targetDigitCount) {
        this.targetDigitCount = targetDigitCount;
    }

    public FormFieldDefinition minimumCharacterCount(Integer minimumCharacterCount) {
        this.minimumCharacterCount = minimumCharacterCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the target number of digits in the field; useful for fixed-length fields")
    @JsonProperty(value="MinimumCharacterCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinimumCharacterCount() {
        return this.minimumCharacterCount;
    }

    public void setMinimumCharacterCount(Integer minimumCharacterCount) {
        this.minimumCharacterCount = minimumCharacterCount;
    }

    public FormFieldDefinition allowNumericDigits(Boolean allowNumericDigits) {
        this.allowNumericDigits = allowNumericDigits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - set to false to block values that contain numeric digits, set to true to allow numeric digits")
    @JsonProperty(value="AllowNumericDigits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowNumericDigits() {
        return this.allowNumericDigits;
    }

    public void setAllowNumericDigits(Boolean allowNumericDigits) {
        this.allowNumericDigits = allowNumericDigits;
    }

    public FormFieldDefinition verticalAlignmentType(String verticalAlignmentType) {
        this.verticalAlignmentType = verticalAlignmentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Vertical alignment of target value area relative to the field anchor; Possible values are VCenter, Top, Bottom")
    @JsonProperty(value="VerticalAlignmentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerticalAlignmentType() {
        return this.verticalAlignmentType;
    }

    public void setVerticalAlignmentType(String verticalAlignmentType) {
        this.verticalAlignmentType = verticalAlignmentType;
    }

    public FormFieldDefinition horizontalAlignmentType(String horizontalAlignmentType) {
        this.horizontalAlignmentType = horizontalAlignmentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Horizontal alignment of target value area relative to the field anchor; Possible values are Left, Right")
    @JsonProperty(value="HorizontalAlignmentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHorizontalAlignmentType() {
        return this.horizontalAlignmentType;
    }

    public void setHorizontalAlignmentType(String horizontalAlignmentType) {
        this.horizontalAlignmentType = horizontalAlignmentType;
    }

    public FormFieldDefinition targetFieldWidthRelative(Double targetFieldWidthRelative) {
        this.targetFieldWidthRelative = targetFieldWidthRelative;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - scale factor for target field width - relative to width of field title; a value of 1.0 indicates the target value area has the same width as the field value as occurring in the image; a value of 2.0 would indicate that the target value area has 2 times the width of the field value as occurring in the image.")
    @JsonProperty(value="TargetFieldWidth_Relative")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTargetFieldWidthRelative() {
        return this.targetFieldWidthRelative;
    }

    public void setTargetFieldWidthRelative(Double targetFieldWidthRelative) {
        this.targetFieldWidthRelative = targetFieldWidthRelative;
    }

    public FormFieldDefinition targetFieldHeightRelative(Double targetFieldHeightRelative) {
        this.targetFieldHeightRelative = targetFieldHeightRelative;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - scale factor for target field height - relative to height of field title")
    @JsonProperty(value="TargetFieldHeight_Relative")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTargetFieldHeightRelative() {
        return this.targetFieldHeightRelative;
    }

    public void setTargetFieldHeightRelative(Double targetFieldHeightRelative) {
        this.targetFieldHeightRelative = targetFieldHeightRelative;
    }

    public FormFieldDefinition targetFieldHorizontalAdjustment(Double targetFieldHorizontalAdjustment) {
        this.targetFieldHorizontalAdjustment = targetFieldHorizontalAdjustment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - horizontal adjestment in relative width of the field")
    @JsonProperty(value="TargetFieldHorizontalAdjustment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTargetFieldHorizontalAdjustment() {
        return this.targetFieldHorizontalAdjustment;
    }

    public void setTargetFieldHorizontalAdjustment(Double targetFieldHorizontalAdjustment) {
        this.targetFieldHorizontalAdjustment = targetFieldHorizontalAdjustment;
    }

    public FormFieldDefinition targetFieldVerticalAdjustment(Double targetFieldVerticalAdjustment) {
        this.targetFieldVerticalAdjustment = targetFieldVerticalAdjustment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - vertical adjestment in relative height of the field")
    @JsonProperty(value="TargetFieldVerticalAdjustment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTargetFieldVerticalAdjustment() {
        return this.targetFieldVerticalAdjustment;
    }

    public void setTargetFieldVerticalAdjustment(Double targetFieldVerticalAdjustment) {
        this.targetFieldVerticalAdjustment = targetFieldVerticalAdjustment;
    }

    public FormFieldDefinition ignore(List<String> ignore) {
        this.ignore = ignore;
        return this;
    }

    public FormFieldDefinition addIgnoreItem(String ignoreItem) {
        if (this.ignore == null) {
            this.ignore = new ArrayList<String>();
        }
        this.ignore.add(ignoreItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - Ignore any result items that contain a partial or complete match with these text strings")
    @JsonProperty(value="Ignore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIgnore() {
        return this.ignore;
    }

    public void setIgnore(List<String> ignore) {
        this.ignore = ignore;
    }

    public FormFieldDefinition options(String options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - additional options that can be set for this field definition, separated by commas.  Possible values are AllowMultiMatch (allow the same anchor to be matched to multiple fields)")
    @JsonProperty(value="Options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormFieldDefinition formFieldDefinition = (FormFieldDefinition)o;
        return Objects.equals(this.fieldID, formFieldDefinition.fieldID) && Objects.equals(this.leftAnchor, formFieldDefinition.leftAnchor) && Objects.equals(this.topAnchor, formFieldDefinition.topAnchor) && Objects.equals(this.bottomAnchor, formFieldDefinition.bottomAnchor) && Objects.equals(this.alternateAnchor, formFieldDefinition.alternateAnchor) && Objects.equals(this.anchorMode, formFieldDefinition.anchorMode) && Objects.equals(this.dataType, formFieldDefinition.dataType) && Objects.equals(this.targetDigitCount, formFieldDefinition.targetDigitCount) && Objects.equals(this.minimumCharacterCount, formFieldDefinition.minimumCharacterCount) && Objects.equals(this.allowNumericDigits, formFieldDefinition.allowNumericDigits) && Objects.equals(this.verticalAlignmentType, formFieldDefinition.verticalAlignmentType) && Objects.equals(this.horizontalAlignmentType, formFieldDefinition.horizontalAlignmentType) && Objects.equals(this.targetFieldWidthRelative, formFieldDefinition.targetFieldWidthRelative) && Objects.equals(this.targetFieldHeightRelative, formFieldDefinition.targetFieldHeightRelative) && Objects.equals(this.targetFieldHorizontalAdjustment, formFieldDefinition.targetFieldHorizontalAdjustment) && Objects.equals(this.targetFieldVerticalAdjustment, formFieldDefinition.targetFieldVerticalAdjustment) && Objects.equals(this.ignore, formFieldDefinition.ignore) && Objects.equals(this.options, formFieldDefinition.options);
    }

    public int hashCode() {
        return Objects.hash(this.fieldID, this.leftAnchor, this.topAnchor, this.bottomAnchor, this.alternateAnchor, this.anchorMode, this.dataType, this.targetDigitCount, this.minimumCharacterCount, this.allowNumericDigits, this.verticalAlignmentType, this.horizontalAlignmentType, this.targetFieldWidthRelative, this.targetFieldHeightRelative, this.targetFieldHorizontalAdjustment, this.targetFieldVerticalAdjustment, this.ignore, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormFieldDefinition {\n");
        sb.append("    fieldID: ").append(this.toIndentedString(this.fieldID)).append("\n");
        sb.append("    leftAnchor: ").append(this.toIndentedString(this.leftAnchor)).append("\n");
        sb.append("    topAnchor: ").append(this.toIndentedString(this.topAnchor)).append("\n");
        sb.append("    bottomAnchor: ").append(this.toIndentedString(this.bottomAnchor)).append("\n");
        sb.append("    alternateAnchor: ").append(this.toIndentedString(this.alternateAnchor)).append("\n");
        sb.append("    anchorMode: ").append(this.toIndentedString(this.anchorMode)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    targetDigitCount: ").append(this.toIndentedString(this.targetDigitCount)).append("\n");
        sb.append("    minimumCharacterCount: ").append(this.toIndentedString(this.minimumCharacterCount)).append("\n");
        sb.append("    allowNumericDigits: ").append(this.toIndentedString(this.allowNumericDigits)).append("\n");
        sb.append("    verticalAlignmentType: ").append(this.toIndentedString(this.verticalAlignmentType)).append("\n");
        sb.append("    horizontalAlignmentType: ").append(this.toIndentedString(this.horizontalAlignmentType)).append("\n");
        sb.append("    targetFieldWidthRelative: ").append(this.toIndentedString(this.targetFieldWidthRelative)).append("\n");
        sb.append("    targetFieldHeightRelative: ").append(this.toIndentedString(this.targetFieldHeightRelative)).append("\n");
        sb.append("    targetFieldHorizontalAdjustment: ").append(this.toIndentedString(this.targetFieldHorizontalAdjustment)).append("\n");
        sb.append("    targetFieldVerticalAdjustment: ").append(this.toIndentedString(this.targetFieldVerticalAdjustment)).append("\n");
        sb.append("    ignore: ").append(this.toIndentedString(this.ignore)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

