/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Individual instance of text occuring in an image; one piece of text")
@JsonPropertyOrder(value={"TopLeftX", "TopLeftY", "TopRightX", "TopRightY", "BottomLeftX", "BottomLeftY", "BottomRightX", "BottomRightY", "Width", "Height", "Angle"})
@JsonTypeName(value="FineTextItem")
public class FineTextItem {
    public static final String JSON_PROPERTY_TOP_LEFT_X = "TopLeftX";
    private Integer topLeftX;
    public static final String JSON_PROPERTY_TOP_LEFT_Y = "TopLeftY";
    private Integer topLeftY;
    public static final String JSON_PROPERTY_TOP_RIGHT_X = "TopRightX";
    private Integer topRightX;
    public static final String JSON_PROPERTY_TOP_RIGHT_Y = "TopRightY";
    private Integer topRightY;
    public static final String JSON_PROPERTY_BOTTOM_LEFT_X = "BottomLeftX";
    private Integer bottomLeftX;
    public static final String JSON_PROPERTY_BOTTOM_LEFT_Y = "BottomLeftY";
    private Integer bottomLeftY;
    public static final String JSON_PROPERTY_BOTTOM_RIGHT_X = "BottomRightX";
    private Integer bottomRightX;
    public static final String JSON_PROPERTY_BOTTOM_RIGHT_Y = "BottomRightY";
    private Integer bottomRightY;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_ANGLE = "Angle";
    private Double angle;

    public FineTextItem topLeftX(Integer topLeftX) {
        this.topLeftX = topLeftX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the top/left text location; 0 represents the left edge of the input image")
    @JsonProperty(value="TopLeftX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopLeftX() {
        return this.topLeftX;
    }

    public void setTopLeftX(Integer topLeftX) {
        this.topLeftX = topLeftX;
    }

    public FineTextItem topLeftY(Integer topLeftY) {
        this.topLeftY = topLeftY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the top/left text location; 0 represents the top edge of the input image")
    @JsonProperty(value="TopLeftY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopLeftY() {
        return this.topLeftY;
    }

    public void setTopLeftY(Integer topLeftY) {
        this.topLeftY = topLeftY;
    }

    public FineTextItem topRightX(Integer topRightX) {
        this.topRightX = topRightX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the top/right text location; 0 represents the left edge of the input image")
    @JsonProperty(value="TopRightX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopRightX() {
        return this.topRightX;
    }

    public void setTopRightX(Integer topRightX) {
        this.topRightX = topRightX;
    }

    public FineTextItem topRightY(Integer topRightY) {
        this.topRightY = topRightY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the top/right text location; 0 represents the top edge of the input image")
    @JsonProperty(value="TopRightY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopRightY() {
        return this.topRightY;
    }

    public void setTopRightY(Integer topRightY) {
        this.topRightY = topRightY;
    }

    public FineTextItem bottomLeftX(Integer bottomLeftX) {
        this.bottomLeftX = bottomLeftX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the bottom/left text location; 0 represents the left edge of the input image")
    @JsonProperty(value="BottomLeftX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBottomLeftX() {
        return this.bottomLeftX;
    }

    public void setBottomLeftX(Integer bottomLeftX) {
        this.bottomLeftX = bottomLeftX;
    }

    public FineTextItem bottomLeftY(Integer bottomLeftY) {
        this.bottomLeftY = bottomLeftY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the bottom/left text location; 0 represents the top edge of the input image")
    @JsonProperty(value="BottomLeftY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBottomLeftY() {
        return this.bottomLeftY;
    }

    public void setBottomLeftY(Integer bottomLeftY) {
        this.bottomLeftY = bottomLeftY;
    }

    public FineTextItem bottomRightX(Integer bottomRightX) {
        this.bottomRightX = bottomRightX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the bottom/right text location; 0 represents the left edge of the input image")
    @JsonProperty(value="BottomRightX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBottomRightX() {
        return this.bottomRightX;
    }

    public void setBottomRightX(Integer bottomRightX) {
        this.bottomRightX = bottomRightX;
    }

    public FineTextItem bottomRightY(Integer bottomRightY) {
        this.bottomRightY = bottomRightY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the bottom/right text location; 0 represents the top edge of the input image")
    @JsonProperty(value="BottomRightY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBottomRightY() {
        return this.bottomRightY;
    }

    public void setBottomRightY(Integer bottomRightY) {
        this.bottomRightY = bottomRightY;
    }

    public FineTextItem width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width in pixels of the text")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public FineTextItem height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height in pixels of the text")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public FineTextItem angle(Double angle) {
        this.angle = angle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rotation Angle in radians of the text")
    @JsonProperty(value="Angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getAngle() {
        return this.angle;
    }

    public void setAngle(Double angle) {
        this.angle = angle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FineTextItem fineTextItem = (FineTextItem)o;
        return Objects.equals(this.topLeftX, fineTextItem.topLeftX) && Objects.equals(this.topLeftY, fineTextItem.topLeftY) && Objects.equals(this.topRightX, fineTextItem.topRightX) && Objects.equals(this.topRightY, fineTextItem.topRightY) && Objects.equals(this.bottomLeftX, fineTextItem.bottomLeftX) && Objects.equals(this.bottomLeftY, fineTextItem.bottomLeftY) && Objects.equals(this.bottomRightX, fineTextItem.bottomRightX) && Objects.equals(this.bottomRightY, fineTextItem.bottomRightY) && Objects.equals(this.width, fineTextItem.width) && Objects.equals(this.height, fineTextItem.height) && Objects.equals(this.angle, fineTextItem.angle);
    }

    public int hashCode() {
        return Objects.hash(this.topLeftX, this.topLeftY, this.topRightX, this.topRightY, this.bottomLeftX, this.bottomLeftY, this.bottomRightX, this.bottomRightY, this.width, this.height, this.angle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FineTextItem {\n");
        sb.append("    topLeftX: ").append(this.toIndentedString(this.topLeftX)).append("\n");
        sb.append("    topLeftY: ").append(this.toIndentedString(this.topLeftY)).append("\n");
        sb.append("    topRightX: ").append(this.toIndentedString(this.topRightX)).append("\n");
        sb.append("    topRightY: ").append(this.toIndentedString(this.topRightY)).append("\n");
        sb.append("    bottomLeftX: ").append(this.toIndentedString(this.bottomLeftX)).append("\n");
        sb.append("    bottomLeftY: ").append(this.toIndentedString(this.bottomLeftY)).append("\n");
        sb.append("    bottomRightX: ").append(this.toIndentedString(this.bottomRightX)).append("\n");
        sb.append("    bottomRightY: ").append(this.toIndentedString(this.bottomRightY)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

